/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import org.exparity.hamcrest.date.core.IsAfter;
import org.exparity.hamcrest.date.core.IsBefore;
import org.exparity.hamcrest.date.core.IsDayOfMonth;
import org.exparity.hamcrest.date.core.IsDayOfWeek;
import org.exparity.hamcrest.date.core.IsFirstDayOfMonth;
import org.exparity.hamcrest.date.core.IsHour;
import org.exparity.hamcrest.date.core.IsLastDayOfMonth;
import org.exparity.hamcrest.date.core.IsLeapYear;
import org.exparity.hamcrest.date.core.IsMaximum;
import org.exparity.hamcrest.date.core.IsMinimum;
import org.exparity.hamcrest.date.core.IsMinute;
import org.exparity.hamcrest.date.core.IsMonth;
import org.exparity.hamcrest.date.core.IsSame;
import org.exparity.hamcrest.date.core.IsSameDay;
import org.exparity.hamcrest.date.core.IsSameOrAfter;
import org.exparity.hamcrest.date.core.IsSameOrBefore;
import org.exparity.hamcrest.date.core.IsSecond;
import org.exparity.hamcrest.date.core.IsWithin;
import org.exparity.hamcrest.date.core.IsYear;
import org.exparity.hamcrest.date.core.TemporalConverters;
import org.exparity.hamcrest.date.core.TemporalFunctions;
import org.exparity.hamcrest.date.core.TemporalMatcher;
import org.exparity.hamcrest.date.core.TemporalProviders;
import org.exparity.hamcrest.date.core.types.Interval;
import org.hamcrest.Factory;

public abstract class ZonedDateTimeMatchers {
    public static TemporalMatcher<ZonedDateTime> after(ZonedDateTime date) {
        return new IsAfter<ZonedDateTime, ZonedDateTime>(TemporalConverters.ZONEDDATETIME_AS_ZONEDDATETIME, TemporalProviders.zonedDateTime(date), TemporalFunctions.ZONEDDATETIME);
    }

    public static TemporalMatcher<ZonedDateTime> after(int year, Month month, int dayOfMonth, int hour, int minute, int second, int nanos, ZoneId tz) {
        return ZonedDateTimeMatchers.after(ZonedDateTime.of(year, month.getValue(), dayOfMonth, hour, minute, second, nanos, tz));
    }

    public static TemporalMatcher<ZonedDateTime> before(ZonedDateTime date) {
        return new IsBefore<ZonedDateTime, ZonedDateTime>(TemporalConverters.ZONEDDATETIME_AS_ZONEDDATETIME, TemporalProviders.zonedDateTime(date), TemporalFunctions.ZONEDDATETIME);
    }

    public static TemporalMatcher<ZonedDateTime> before(int year, Month month, int dayOfMonth, int hour, int minute, int second, int nanos, ZoneId tz) {
        return ZonedDateTimeMatchers.before(ZonedDateTime.of(year, month.getValue(), dayOfMonth, hour, minute, second, nanos, tz));
    }

    public static TemporalMatcher<ZonedDateTime> sameDay(ZonedDateTime date) {
        return new IsSameDay<ZonedDateTime>(TemporalConverters.ZONEDDATETIME_AS_LOCALDATE, TemporalProviders.localDate(date));
    }

    public static TemporalMatcher<ZonedDateTime> isDay(LocalDate date) {
        return new IsSameDay<ZonedDateTime>(TemporalConverters.ZONEDDATETIME_AS_LOCALDATE, TemporalProviders.localDate(date));
    }

    public static TemporalMatcher<ZonedDateTime> isDay(int year, Month month, int dayOfMonth) {
        return ZonedDateTimeMatchers.isDay(LocalDate.of(year, month, dayOfMonth));
    }

    public static TemporalMatcher<ZonedDateTime> isDay(int year, Month month, int dayOfMonth, ZoneId zone) {
        return ZonedDateTimeMatchers.isDay(LocalDate.of(year, month, dayOfMonth)).atZone(zone);
    }

    public static TemporalMatcher<ZonedDateTime> sameInstant(ZonedDateTime date) {
        return new IsSame<ZonedDateTime, ZonedDateTime>(TemporalConverters.ZONEDDATETIME_AS_ZONEDDATETIME, TemporalProviders.zonedDateTime(date), TemporalFunctions.ZONEDDATETIME);
    }

    public static TemporalMatcher<ZonedDateTime> isInstant(int year, Month month, int dayOfMonth, int hour, int minute, int second, int nanos, ZoneId tz) {
        return ZonedDateTimeMatchers.sameInstant(ZonedDateTime.of(year, month.getValue(), dayOfMonth, hour, minute, second, nanos, tz));
    }

    public static TemporalMatcher<ZonedDateTime> sameOrBefore(ZonedDateTime date) {
        return new IsSameOrBefore<ZonedDateTime, ZonedDateTime>(TemporalConverters.ZONEDDATETIME_AS_ZONEDDATETIME, TemporalProviders.zonedDateTime(date), TemporalFunctions.ZONEDDATETIME);
    }

    @Factory
    public static TemporalMatcher<ZonedDateTime> sameOrBefore(int year, Month month, int day, int hour, int minute, int second, int nanos, ZoneId tz) {
        return ZonedDateTimeMatchers.sameOrBefore(ZonedDateTime.of(year, month.getValue(), day, hour, minute, second, nanos, tz));
    }

    public static TemporalMatcher<ZonedDateTime> sameOrAfter(ZonedDateTime date) {
        return new IsSameOrAfter<ZonedDateTime, ZonedDateTime>(TemporalConverters.ZONEDDATETIME_AS_ZONEDDATETIME, TemporalProviders.zonedDateTime(date), TemporalFunctions.ZONEDDATETIME);
    }

    @Factory
    public static TemporalMatcher<ZonedDateTime> sameOrAfter(int year, Month month, int day, int hour, int minute, int second, int nanos, ZoneId tz) {
        return ZonedDateTimeMatchers.sameOrAfter(ZonedDateTime.of(year, month.getValue(), day, hour, minute, second, nanos, tz));
    }

    public static TemporalMatcher<ZonedDateTime> sameMonthOfYear(ZonedDateTime date) {
        return new IsMonth<ZonedDateTime>(TemporalConverters.ZONEDDATETIME_AS_MONTH, TemporalProviders.month(date));
    }

    public static TemporalMatcher<ZonedDateTime> sameDayOfMonth(ZonedDateTime date) {
        return new IsDayOfMonth<ZonedDateTime>(TemporalConverters.ZONEDDATETIME_AS_DAYOFMONTH, TemporalProviders.dayOfMonth(date));
    }

    public static TemporalMatcher<ZonedDateTime> isDayOfMonth(int dayOfMonth) {
        return new IsDayOfMonth<ZonedDateTime>(TemporalConverters.ZONEDDATETIME_AS_DAYOFMONTH, TemporalProviders.dayOfMonth(dayOfMonth));
    }

    public static TemporalMatcher<ZonedDateTime> sameYear(ZonedDateTime date) {
        return ZonedDateTimeMatchers.isYear(date.getYear());
    }

    public static TemporalMatcher<ZonedDateTime> isYear(int year) {
        return new IsYear<ZonedDateTime>(TemporalConverters.ZONEDDATETIME_AS_YEAR, TemporalProviders.year(year));
    }

    public static TemporalMatcher<ZonedDateTime> within(long period, ChronoUnit unit, ZonedDateTime date) {
        return new IsWithin<ZonedDateTime, ZonedDateTime>(Interval.of(period, unit), TemporalConverters.ZONEDDATETIME_AS_ZONEDDATETIME, TemporalProviders.zonedDateTime(date), TemporalFunctions.ZONEDDATETIME);
    }

    public static TemporalMatcher<ZonedDateTime> within(long period, ChronoUnit unit, int year, Month month, int dayofMonth, int hour, int minute, int second, int nanos, ZoneId tz) {
        return ZonedDateTimeMatchers.within(period, unit, ZonedDateTime.of(year, month.getValue(), dayofMonth, hour, minute, second, nanos, tz));
    }

    public static TemporalMatcher<ZonedDateTime> isYesterday() {
        return ZonedDateTimeMatchers.sameDay(ZonedDateTime.now().plusDays(-1L));
    }

    public static TemporalMatcher<ZonedDateTime> isToday() {
        return ZonedDateTimeMatchers.sameDay(ZonedDateTime.now());
    }

    public static TemporalMatcher<ZonedDateTime> isTomorrow() {
        return ZonedDateTimeMatchers.sameDay(ZonedDateTime.now().plusDays(1L));
    }

    public static TemporalMatcher<ZonedDateTime> sameDayOfWeek(ZonedDateTime date) {
        return ZonedDateTimeMatchers.isDayOfWeek(DayOfWeek.from(date));
    }

    public static TemporalMatcher<ZonedDateTime> isDayOfWeek(DayOfWeek dayOfWeek) {
        return new IsDayOfWeek<ZonedDateTime>(TemporalConverters.ZONEDDATETIME_AS_DAYOFWEEK, TemporalProviders.daysOfWeek(dayOfWeek));
    }

    public static TemporalMatcher<ZonedDateTime> isDayOfWeek(DayOfWeek ... daysOfWeek) {
        return new IsDayOfWeek<ZonedDateTime>(TemporalConverters.ZONEDDATETIME_AS_DAYOFWEEK, TemporalProviders.daysOfWeek(daysOfWeek));
    }

    public static TemporalMatcher<ZonedDateTime> isMonday() {
        return ZonedDateTimeMatchers.isDayOfWeek(DayOfWeek.MONDAY);
    }

    public static TemporalMatcher<ZonedDateTime> isTuesday() {
        return ZonedDateTimeMatchers.isDayOfWeek(DayOfWeek.TUESDAY);
    }

    public static TemporalMatcher<ZonedDateTime> isWednesday() {
        return ZonedDateTimeMatchers.isDayOfWeek(DayOfWeek.WEDNESDAY);
    }

    public static TemporalMatcher<ZonedDateTime> isThursday() {
        return ZonedDateTimeMatchers.isDayOfWeek(DayOfWeek.THURSDAY);
    }

    public static TemporalMatcher<ZonedDateTime> isFriday() {
        return ZonedDateTimeMatchers.isDayOfWeek(DayOfWeek.FRIDAY);
    }

    public static TemporalMatcher<ZonedDateTime> isSaturday() {
        return ZonedDateTimeMatchers.isDayOfWeek(DayOfWeek.SATURDAY);
    }

    public static TemporalMatcher<ZonedDateTime> isSunday() {
        return ZonedDateTimeMatchers.isDayOfWeek(DayOfWeek.SUNDAY);
    }

    public static TemporalMatcher<ZonedDateTime> isWeekday() {
        return ZonedDateTimeMatchers.isDayOfWeek(DayOfWeek.MONDAY, DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY);
    }

    public static TemporalMatcher<ZonedDateTime> isWeekend() {
        return ZonedDateTimeMatchers.isDayOfWeek(DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    public static TemporalMatcher<ZonedDateTime> isFirstDayOfMonth() {
        return new IsFirstDayOfMonth<ZonedDateTime>(TemporalConverters.ZONEDDATETIME_AS_ZONEDDATETIME);
    }

    public static TemporalMatcher<ZonedDateTime> isMinimum(ChronoField field) {
        return new IsMinimum<ZonedDateTime>(TemporalConverters.ZONEDDATETIME_AS_ZONEDDATETIME, field);
    }

    public static TemporalMatcher<ZonedDateTime> isLastDayOfMonth() {
        return new IsLastDayOfMonth<ZonedDateTime>(TemporalConverters.ZONEDDATETIME_AS_ZONEDDATETIME);
    }

    public static TemporalMatcher<ZonedDateTime> isMaximum(ChronoField field) {
        return new IsMaximum<ZonedDateTime>(TemporalConverters.ZONEDDATETIME_AS_ZONEDDATETIME, field);
    }

    public static TemporalMatcher<ZonedDateTime> isMonth(Month month) {
        return new IsMonth<ZonedDateTime>(TemporalConverters.ZONEDDATETIME_AS_MONTH, TemporalProviders.month(month));
    }

    public static TemporalMatcher<ZonedDateTime> isJanuary() {
        return ZonedDateTimeMatchers.isMonth(Month.JANUARY);
    }

    public static TemporalMatcher<ZonedDateTime> isFebruary() {
        return ZonedDateTimeMatchers.isMonth(Month.FEBRUARY);
    }

    public static TemporalMatcher<ZonedDateTime> isMarch() {
        return ZonedDateTimeMatchers.isMonth(Month.MARCH);
    }

    public static TemporalMatcher<ZonedDateTime> isApril() {
        return ZonedDateTimeMatchers.isMonth(Month.APRIL);
    }

    public static TemporalMatcher<ZonedDateTime> isMay() {
        return ZonedDateTimeMatchers.isMonth(Month.MAY);
    }

    public static TemporalMatcher<ZonedDateTime> isJune() {
        return ZonedDateTimeMatchers.isMonth(Month.JUNE);
    }

    public static TemporalMatcher<ZonedDateTime> isJuly() {
        return ZonedDateTimeMatchers.isMonth(Month.JULY);
    }

    public static TemporalMatcher<ZonedDateTime> isAugust() {
        return ZonedDateTimeMatchers.isMonth(Month.AUGUST);
    }

    public static TemporalMatcher<ZonedDateTime> isSeptember() {
        return ZonedDateTimeMatchers.isMonth(Month.SEPTEMBER);
    }

    public static TemporalMatcher<ZonedDateTime> isOctober() {
        return ZonedDateTimeMatchers.isMonth(Month.OCTOBER);
    }

    public static TemporalMatcher<ZonedDateTime> isNovember() {
        return ZonedDateTimeMatchers.isMonth(Month.NOVEMBER);
    }

    public static TemporalMatcher<ZonedDateTime> isDecember() {
        return ZonedDateTimeMatchers.isMonth(Month.DECEMBER);
    }

    public static TemporalMatcher<ZonedDateTime> isLeapYear() {
        return new IsLeapYear<ZonedDateTime>(TemporalConverters.ZONEDDATETIME_AS_YEAR);
    }

    public static TemporalMatcher<ZonedDateTime> isHour(int hour) {
        return new IsHour<ZonedDateTime>(TemporalConverters.ZONEDDATETIME_AS_HOUR, TemporalProviders.hour(hour));
    }

    public static TemporalMatcher<ZonedDateTime> sameHourOfDay(ZonedDateTime date) {
        return new IsHour<ZonedDateTime>(TemporalConverters.ZONEDDATETIME_AS_HOUR, TemporalProviders.hour(date));
    }

    public static TemporalMatcher<ZonedDateTime> isMinute(int minute) {
        return new IsMinute<ZonedDateTime>(TemporalConverters.ZONEDDATETIME_AS_MINUTE, TemporalProviders.minute(minute));
    }

    public static TemporalMatcher<ZonedDateTime> sameMinuteOfHour(ZonedDateTime date) {
        return new IsMinute<ZonedDateTime>(TemporalConverters.ZONEDDATETIME_AS_MINUTE, TemporalProviders.minute(date));
    }

    public static TemporalMatcher<ZonedDateTime> isSecond(int second) {
        return new IsSecond<ZonedDateTime>(TemporalConverters.ZONEDDATETIME_AS_SECOND, TemporalProviders.second(second));
    }

    public static TemporalMatcher<ZonedDateTime> sameSecondOfMinute(ZonedDateTime date) {
        return new IsSecond<ZonedDateTime>(TemporalConverters.ZONEDDATETIME_AS_SECOND, TemporalProviders.second(date));
    }
}

