/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date;

import java.time.LocalTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import org.exparity.hamcrest.date.core.IsAfter;
import org.exparity.hamcrest.date.core.IsBefore;
import org.exparity.hamcrest.date.core.IsHour;
import org.exparity.hamcrest.date.core.IsMaximum;
import org.exparity.hamcrest.date.core.IsMinimum;
import org.exparity.hamcrest.date.core.IsMinute;
import org.exparity.hamcrest.date.core.IsSameOrAfter;
import org.exparity.hamcrest.date.core.IsSameOrBefore;
import org.exparity.hamcrest.date.core.IsSecond;
import org.exparity.hamcrest.date.core.IsWithin;
import org.exparity.hamcrest.date.core.TemporalConverters;
import org.exparity.hamcrest.date.core.TemporalFunctions;
import org.exparity.hamcrest.date.core.TemporalProviders;
import org.exparity.hamcrest.date.core.types.Interval;
import org.hamcrest.Matcher;

public abstract class LocalTimeMatchers {
    public static Matcher<LocalTime> after(LocalTime time) {
        return new IsAfter<LocalTime, LocalTime>(TemporalConverters.LOCALTIME_AS_LOCALTIME, TemporalProviders.localTime(time), TemporalFunctions.LOCALTIME);
    }

    public static Matcher<LocalTime> after(int hour, int minute, int second) {
        return LocalTimeMatchers.after(LocalTime.of(hour, minute, second));
    }

    public static Matcher<LocalTime> before(LocalTime time) {
        return new IsBefore<LocalTime, LocalTime>(TemporalConverters.LOCALTIME_AS_LOCALTIME, TemporalProviders.localTime(time), TemporalFunctions.LOCALTIME);
    }

    public static Matcher<LocalTime> before(int hour, int minute, int second) {
        return LocalTimeMatchers.before(LocalTime.of(hour, minute, second));
    }

    public static Matcher<LocalTime> sameOrBefore(LocalTime time) {
        return new IsSameOrBefore<LocalTime, LocalTime>(TemporalConverters.LOCALTIME_AS_LOCALTIME, TemporalProviders.localTime(time), TemporalFunctions.LOCALTIME);
    }

    public static Matcher<LocalTime> sameOrBefore(int hour, int minute, int second) {
        return LocalTimeMatchers.sameOrBefore(LocalTime.of(hour, minute, second));
    }

    public static Matcher<LocalTime> sameOrAfter(LocalTime time) {
        return new IsSameOrAfter<LocalTime, LocalTime>(TemporalConverters.LOCALTIME_AS_LOCALTIME, TemporalProviders.localTime(time), TemporalFunctions.LOCALTIME);
    }

    public static Matcher<LocalTime> sameOrAfter(int hour, int minute, int second) {
        return LocalTimeMatchers.sameOrAfter(LocalTime.of(hour, minute, second));
    }

    public static Matcher<LocalTime> within(long period, ChronoUnit unit, LocalTime time) {
        return new IsWithin<LocalTime, LocalTime>(Interval.of(period, unit), TemporalConverters.LOCALTIME_AS_LOCALTIME, TemporalProviders.localTime(time), TemporalFunctions.LOCALTIME);
    }

    public static Matcher<LocalTime> within(long period, ChronoUnit unit, int hour, int minute, int second) {
        return LocalTimeMatchers.within(period, unit, LocalTime.of(hour, minute, second));
    }

    public static Matcher<LocalTime> isMinimum(ChronoField field) {
        return new IsMinimum<LocalTime>(TemporalConverters.LOCALTIME_AS_LOCALTIME, field);
    }

    public static Matcher<LocalTime> isMaximum(ChronoField field) {
        return new IsMaximum<LocalTime>(TemporalConverters.LOCALTIME_AS_LOCALTIME, field);
    }

    public static Matcher<LocalTime> isHour(int hour) {
        return new IsHour<LocalTime>(TemporalConverters.LOCALTIME_AS_HOUR, TemporalProviders.hour(hour));
    }

    public static Matcher<LocalTime> sameHourOfDay(LocalTime time) {
        return new IsHour<LocalTime>(TemporalConverters.LOCALTIME_AS_HOUR, TemporalProviders.hour(time));
    }

    public static Matcher<LocalTime> isMinute(int minute) {
        return new IsMinute<LocalTime>(TemporalConverters.LOCALTIME_AS_MINUTE, TemporalProviders.minute(minute));
    }

    public static Matcher<LocalTime> sameMinuteOfHour(LocalTime time) {
        return new IsMinute<LocalTime>(TemporalConverters.LOCALTIME_AS_MINUTE, TemporalProviders.minute(time));
    }

    public static Matcher<LocalTime> isSecond(int second) {
        return new IsSecond<LocalTime>(TemporalConverters.LOCALTIME_AS_SECOND, TemporalProviders.second(second));
    }

    public static Matcher<LocalTime> sameSecondOfMinute(LocalTime time) {
        return new IsSecond<LocalTime>(TemporalConverters.LOCALTIME_AS_SECOND, TemporalProviders.second(time));
    }
}

