/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.functions;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import kg.apc.jmeter.JMeterPluginsUtils;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterVariables;

public class Env
extends AbstractFunction {
    private static final List<String> desc = new LinkedList<String>();
    private static final String KEY = "__env";
    private static final int MIN_PARAMETER_COUNT = 1;
    private static final int MAX_PARAMETER_COUNT = 3;
    private CompoundVariable[] values;

    public synchronized String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        JMeterVariables variables;
        String variableName;
        String propertyName;
        String propertyDefault = propertyName = this.values[0].execute();
        if (this.values.length > 2) {
            propertyDefault = this.values[2].execute();
        }
        String propertyValue = JMeterPluginsUtils.getEnvDefault((String)propertyName, (String)propertyDefault);
        if (this.values.length > 1 && (variableName = this.values[1].execute()).length() > 0 && (variables = this.getVariables()) != null) {
            variables.put(variableName, propertyValue);
        }
        return propertyValue;
    }

    public synchronized void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 1, 3);
        this.values = parameters.toArray(new CompoundVariable[0]);
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    static {
        desc.add("Name of environment variable");
        desc.add("Name of variable in which to store the result (optional)");
        desc.add("Default value");
    }
}

