/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.perfmon.metrics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import kg.apc.perfmon.metrics.AbstractPerfMonMetric;
import kg.apc.perfmon.metrics.InvalidPerfMonMetric;
import kg.apc.perfmon.metrics.MetricParamsSigar;
import kg.apc.perfmon.metrics.PerfMonMetricsCreator;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.hyperic.sigar.SigarProxy;

public class PerfMonMetricsService {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static PerfMonMetricsService service;
    private ServiceLoader loader;
    private List metricExceptions = new ArrayList();
    private List triedClasses = new ArrayList();

    private PerfMonMetricsService() {
        this.loader = ServiceLoader.load(PerfMonMetricsCreator.class);
    }

    public static synchronized PerfMonMetricsService getInstance() {
        if (service == null) {
            service = new PerfMonMetricsService();
        }
        return service;
    }

    public AbstractPerfMonMetric getMetric(String metricType, MetricParamsSigar metricParams, SigarProxy sigarProxy, boolean isNoExec) throws IllegalArgumentException, RuntimeException {
        AbstractPerfMonMetric metric = null;
        Iterator mCreators = this.loader.iterator();
        while (metric == null && mCreators.hasNext()) {
            PerfMonMetricsCreator mCreator = (PerfMonMetricsCreator)mCreators.next();
            try {
                metric = mCreator.getMetricProvider(metricType, metricParams, sigarProxy, isNoExec);
            }
            catch (Exception e) {
                log.debug("Error when getting metrics from: " + mCreator.getClass());
                log.debug(e.getMessage());
                this.triedClasses.add(mCreator.getClass());
                this.metricExceptions.add(e);
                metric = null;
            }
        }
        if (metric == null) {
            metric = new InvalidPerfMonMetric();
            log.error("Couldn't get metrics from: " + Arrays.toString(this.triedClasses.toArray()));
            for (int i = 0; i < this.metricExceptions.size(); ++i) {
                log.error(((Exception)this.metricExceptions.get(i)).getMessage());
            }
            throw new RuntimeException("Couldn't get metrics from: " + Arrays.toString(this.triedClasses.toArray()));
        }
        return metric;
    }
}

