/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.perfmon;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kg.apc.jmeter.perfmon.PerfMonAgentConnector;
import kg.apc.jmeter.perfmon.PerfMonSampleGenerator;
import kg.apc.perfmon.client.Transport;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class NewAgentConnector
implements PerfMonAgentConnector {
    private static final Logger log = LoggingManager.getLoggerForClass();
    protected Transport transport;
    private Map<String, String> metrics = new HashMap<String, String>();
    private String[] metricLabels;

    public void setTransport(Transport atransport) {
        this.transport = atransport;
    }

    @Override
    public void connect() throws IOException {
        log.debug(this.metrics.toString());
        ArrayList<String> labels = new ArrayList<String>(this.metrics.keySet());
        this.metricLabels = labels.toArray(new String[labels.size()]);
        ArrayList<String> arr = new ArrayList<String>(this.metrics.values());
        String[] m = arr.toArray(new String[arr.size()]);
        this.transport.startWithMetrics(m);
    }

    @Override
    public void disconnect() {
        this.transport.disconnect();
    }

    @Override
    public void generateSamples(PerfMonSampleGenerator collector) throws IOException {
        String[] data = this.transport.readMetrics();
        for (int n = 0; n < data.length; ++n) {
            if (data[n].isEmpty()) continue;
            try {
                collector.generateSample(Double.parseDouble(data[n]), this.metricLabels[n]);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
                collector.generateErrorSample(this.metricLabels[n], e.toString());
            }
        }
    }

    @Override
    public void addMetric(String metric, String params, String label) {
        this.metrics.put(label, metric.toLowerCase() + ":" + params);
    }
}

