/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.util.ScriptingBeanInfoSupport;

public abstract class JSR223BeanInfoSupport
extends ScriptingBeanInfoSupport {
    private static final String[] LANGUAGE_TAGS;
    @Deprecated
    public static final String[][] LANGUAGE_NAMES;
    private static final String[][] CONSTANT_LANGUAGE_NAMES;
    private static final ResourceBundle NAME_BUNDLE;

    protected JSR223BeanInfoSupport(Class<? extends TestBean> beanClass) {
        super(beanClass, LANGUAGE_TAGS, NAME_BUNDLE);
    }

    public static final String[][] getLanguageNames() {
        return (String[][])CONSTANT_LANGUAGE_NAMES.clone();
    }

    static {
        HashMap<String, ScriptEngineFactory> nameMap = new HashMap<String, ScriptEngineFactory>();
        ScriptEngineManager sem = new ScriptEngineManager();
        List<ScriptEngineFactory> engineFactories = sem.getEngineFactories();
        for (ScriptEngineFactory fact : engineFactories) {
            List<String> names = fact.getNames();
            for (String shortName : names) {
                nameMap.put(shortName.toLowerCase(Locale.ENGLISH), fact);
            }
        }
        LANGUAGE_TAGS = nameMap.keySet().toArray(new String[nameMap.size()]);
        Arrays.sort(LANGUAGE_TAGS);
        CONSTANT_LANGUAGE_NAMES = new String[nameMap.size()][2];
        int i = 0;
        for (Map.Entry me : nameMap.entrySet()) {
            String key;
            JSR223BeanInfoSupport.CONSTANT_LANGUAGE_NAMES[i][0] = key = (String)me.getKey();
            ScriptEngineFactory fact = (ScriptEngineFactory)me.getValue();
            JSR223BeanInfoSupport.CONSTANT_LANGUAGE_NAMES[i++][1] = key + "     (" + fact.getLanguageName() + " " + fact.getLanguageVersion() + " / " + fact.getEngineName() + " " + fact.getEngineVersion() + ")";
        }
        LANGUAGE_NAMES = JSR223BeanInfoSupport.getLanguageNames();
        NAME_BUNDLE = new ListResourceBundle(){

            @Override
            protected Object[][] getContents() {
                return CONSTANT_LANGUAGE_NAMES;
            }
        };
    }
}

