/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testelement.property;

import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.NumberProperty;

public class LongProperty
extends NumberProperty {
    private static final long serialVersionUID = 240L;
    private long value;
    private long savedValue;

    public LongProperty(String name, long value) {
        super(name);
        this.value = value;
    }

    public LongProperty() {
    }

    @Override
    public void setRunningVersion(boolean runningVersion) {
        this.savedValue = this.value;
        super.setRunningVersion(runningVersion);
    }

    @Override
    public void recoverRunningVersion(TestElement owner) {
        this.value = this.savedValue;
    }

    public void setValue(int value) {
        this.value = value;
    }

    @Override
    protected void setNumberValue(Number n) {
        this.value = n.longValue();
    }

    @Override
    protected void setNumberValue(String n) throws NumberFormatException {
        this.value = Long.parseLong(n);
    }

    @Override
    public String getStringValue() {
        return Long.toString(this.value);
    }

    @Override
    public Object getObjectValue() {
        return this.value;
    }

    @Override
    public LongProperty clone() {
        LongProperty prop = (LongProperty)super.clone();
        prop.value = this.value;
        return prop;
    }

    @Override
    public boolean getBooleanValue() {
        return this.getLongValue() > 0L;
    }

    @Override
    public double getDoubleValue() {
        return this.value;
    }

    @Override
    public float getFloatValue() {
        return this.value;
    }

    @Override
    public int getIntValue() {
        return (int)this.value;
    }

    @Override
    public long getLongValue() {
        return this.value;
    }
}

