/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testelement.property;

import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.NumberProperty;

public class IntegerProperty
extends NumberProperty {
    private static final long serialVersionUID = 240L;
    private int value;
    private int savedValue;

    public IntegerProperty(String name, int value) {
        super(name);
        this.value = value;
    }

    @Override
    public void setRunningVersion(boolean runningVersion) {
        this.savedValue = this.value;
        super.setRunningVersion(runningVersion);
    }

    @Override
    public void recoverRunningVersion(TestElement owner) {
        this.value = this.savedValue;
    }

    public IntegerProperty(String name) {
        super(name);
    }

    public IntegerProperty() {
    }

    public void setValue(int value) {
        this.value = value;
    }

    @Override
    protected void setNumberValue(Number n) {
        this.value = n.intValue();
    }

    @Override
    protected void setNumberValue(String n) throws NumberFormatException {
        this.value = Integer.parseInt(n);
    }

    @Override
    public String getStringValue() {
        return Integer.toString(this.value);
    }

    @Override
    public Object getObjectValue() {
        return this.value;
    }

    @Override
    public IntegerProperty clone() {
        IntegerProperty prop = (IntegerProperty)super.clone();
        prop.value = this.value;
        return prop;
    }

    @Override
    public boolean getBooleanValue() {
        return this.getIntValue() > 0;
    }

    @Override
    public double getDoubleValue() {
        return this.value;
    }

    @Override
    public float getFloatValue() {
        return this.value;
    }

    @Override
    public int getIntValue() {
        return this.value;
    }

    @Override
    public long getLongValue() {
        return this.value;
    }
}

