/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.rmi;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.rmi.server.RMIClientSocketFactory;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.jmeter.rmi.AliasKeyManager;

public class SSLRMIClientSocketFactory
implements RMIClientSocketFactory,
Serializable {
    private static final long serialVersionUID = 1L;
    private String alias;
    private String keyStoreLocation;
    private String keyStorePassword;
    private String keyStoreType;
    private String trustStoreLocation;
    private String trustStorePassword;
    private String trustStoreType;

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setKeystore(String location, String type, String password) {
        this.keyStoreLocation = location;
        this.keyStoreType = type;
        this.keyStorePassword = password;
    }

    public void setTruststore(String location, String type, String password) {
        this.trustStoreLocation = location;
        this.trustStoreType = type;
        this.trustStorePassword = password;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        SSLContext ctx;
        char[] passphrase = null;
        if (this.keyStorePassword != null) {
            passphrase = this.keyStorePassword.toCharArray();
        }
        KeyStore keyStore = null;
        if (this.keyStoreLocation != null) {
            keyStore = this.loadStore(this.keyStoreLocation, passphrase, this.keyStoreType);
        }
        KeyStore trustStore = this.trustStoreLocation != null ? this.loadStore(this.trustStoreLocation, this.trustStorePassword.toCharArray(), this.trustStoreType) : keyStore;
        if (this.alias == null) {
            throw new IOException("SSL certificate alias cannot be null; MUST be set for SSLServerSocketFactory!");
        }
        try {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, passphrase);
            ctx = SSLContext.getInstance("TLS");
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(trustStore);
            ctx.init(AliasKeyManager.wrap(kmf.getKeyManagers(), this.alias), tmf.getTrustManagers(), null);
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
        SSLSocketFactory factory = ctx.getSocketFactory();
        if (factory == null) {
            throw new IOException("Unable to obtain SSLSocketFactory for provided KeyStore");
        }
        return factory.createSocket(host, port);
    }

    private KeyStore loadStore(String location, char[] passphrase, String type) throws IOException {
        try {
            KeyStore store = KeyStore.getInstance(type);
            store.load(new FileInputStream(location), passphrase);
            return store;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IOException("Can't load " + location + " as type " + type, e);
        }
    }

    public String toString() {
        return "SSLRMIClientSocketFactory(keyStoreLocation=" + this.keyStoreLocation + ", type=" + this.keyStoreType + ", trustStoreLocation=" + this.trustStoreLocation + ", type=" + this.trustStoreType + ", alias=" + this.alias + ')';
    }
}

