/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter;

import com.github.weisj.darklaf.icons.ThemedSVGIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplashScreen
extends JDialog {
    private static final Logger log = LoggerFactory.getLogger(SplashScreen.class);
    private static final long serialVersionUID = 1L;
    private final JProgressBar progressBar = new JProgressBar(0, 100);

    public SplashScreen() {
        this.setLayout(new BorderLayout());
        this.add((Component)SplashScreen.loadLogo(), "Center");
        this.add((Component)this.progressBar, "South");
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setAutoRequestFocus(true);
        this.setUndecorated(true);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public static JComponent loadLogo() {
        JLabel logo = new JLabel();
        logo.setBorder(new EmptyBorder(10, 10, 10, 10));
        URI svgUri = null;
        String svgResourcePath = "/org/apache/jmeter/images/logo.svg";
        try {
            URL svgUrl = JMeterUtils.class.getResource(svgResourcePath);
            if (svgUrl != null) {
                svgUri = svgUrl.toURI();
            }
        }
        catch (URISyntaxException e) {
            log.warn("Unable to find logo {}", (Object)svgResourcePath, (Object)e);
        }
        if (svgUri != null) {
            ThemedSVGIcon icon = new ThemedSVGIcon(svgUri, 521, 177);
            logo.setIcon((Icon)icon);
        } else {
            logo.setText("<html><span style=\"font-size:36px;font-family:'Lucida Grande',Corbel,Arial;color:#D11123\">&nbsp;&nbsp;APACHE<br></span><span style=\"font-size:100px;font-family:'Lucida Grande',Corbel,Arial;font-weight:bold\"><span style=\"color:#D11123\">J</span>Meter<span style=\"color:#4d4d4d\">\u2122</span></span></html>");
        }
        return logo;
    }

    public void showScreen() {
        SwingUtilities.invokeLater(() -> this.setVisible(true));
    }

    public void close() {
        SwingUtilities.invokeLater(() -> {
            this.setVisible(false);
            this.dispose();
        });
    }

    public void setProgress(int progress) {
        SwingUtilities.invokeLater(() -> this.progressBar.setValue(progress));
    }
}

