/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.perfmon.metrics;

import javax.management.MBeanServerConnection;
import kg.apc.perfmon.metrics.AbstractPerfMonMetric;
import kg.apc.perfmon.metrics.MetricParams;
import kg.apc.perfmon.metrics.jmx.AbstractJMXDataProvider;
import kg.apc.perfmon.metrics.jmx.JMXConnectorHelper;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class JMXMetric
extends AbstractPerfMonMetric {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private final AbstractJMXDataProvider dataProvider;
    private int dividingFactor = 1;

    public JMXMetric(MetricParams params, JMXConnectorHelper jmxHelper) {
        super(null);
        String url = "localhost:4711";
        String user = "";
        String pwd = "";
        for (int i = 0; i < params.params.length; ++i) {
            if (params.params[i].startsWith("url=")) {
                url = MetricParams.getParamValue(params.params[i]);
                continue;
            }
            if (params.params[i].startsWith("user=")) {
                user = MetricParams.getParamValue(params.params[i]);
                continue;
            }
            if (!params.params[i].startsWith("password=")) continue;
            pwd = MetricParams.getParamValue(params.params[i]);
        }
        if (url.isEmpty()) {
            throw new IllegalArgumentException("'url' parameter required for metric type 'jmx'");
        }
        MBeanServerConnection mBeanServerConn = jmxHelper.getServerConnection(url, user, pwd);
        try {
            this.dataProvider = AbstractJMXDataProvider.getProvider(mBeanServerConn, params.type);
        }
        catch (Exception ex) {
            log.error("Failed to get MX Bean data provider", (Throwable)ex);
            throw new RuntimeException("Failed to get MX Bean data provider", ex);
        }
        this.dividingFactor = this.getUnitDividingFactor(params.getUnit());
    }

    public void getValue(StringBuffer res) throws Exception {
        if (this.dataProvider.isBytesValue()) {
            this.dataProvider.getValue(res, this.dividingFactor);
        } else {
            this.dataProvider.getValue(res);
        }
    }
}

