/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.perfmon;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import kg.apc.perfmon.PerfMonWorker;
import kg.apc.perfmon.metrics.AbstractPerfMonMetric;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.hyperic.sigar.SigarProxy;

public class PerfMonMetricGetter {
    public static final String TAB = "\t";
    public static final String DVOETOCHIE = ":";
    public static final String NEWLINE = "\n";
    private final PerfMonWorker controller;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private String commandString = "";
    private final SelectableChannel channel;
    private AbstractPerfMonMetric[] metrics = new AbstractPerfMonMetric[0];
    private final SigarProxy sigarProxy;
    private SocketAddress udpPeer;

    public PerfMonMetricGetter(SigarProxy aproxy, PerfMonWorker aController, SelectableChannel aChannel) throws IOException {
        this.controller = aController;
        this.channel = aChannel;
        this.sigarProxy = aproxy;
    }

    PerfMonMetricGetter(SigarProxy aproxy, PerfMonWorker aThis, DatagramChannel udpServer, SocketAddress remoteAddr) throws IOException {
        this(aproxy, aThis, udpServer);
        this.udpPeer = remoteAddr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCommand(String command) throws IOException {
        log.debug("Got command line: " + command);
        String cmdType = command.trim();
        String params = "";
        if (command.indexOf(DVOETOCHIE) >= 0) {
            cmdType = command.substring(0, command.indexOf(DVOETOCHIE)).trim();
            params = command.substring(command.indexOf(DVOETOCHIE) + 1).trim();
        }
        if (cmdType.equals("interval")) {
            this.controller.setInterval(Integer.parseInt(params));
        } else if (cmdType.equals("shutdown")) {
            this.controller.shutdownConnections();
        } else if (cmdType.equals("metrics-single")) {
            this.setUpMetrics(params.split(TAB));
            ByteBuffer buf = this.getMetricsLine();
            this.controller.sendToClient(this.channel, buf);
        } else if (cmdType.equals("metrics")) {
            log.info("Starting measures: " + params);
            this.setUpMetrics(params.split(TAB));
            this.controller.registerWritingChannel(this.channel, this);
        } else if (cmdType.equals("exit")) {
            log.info("Client disconnected");
            SelectableChannel buf = this.channel;
            synchronized (buf) {
                this.metrics = new AbstractPerfMonMetric[0];
                if (this.channel instanceof SocketChannel) {
                    this.channel.close();
                } else {
                    log.debug("UDP channel left open to receive data");
                }
            }
            this.controller.notifyDisonnected();
        } else if (cmdType.equals("test")) {
            log.info("Yep, we received the 'test' command");
            if (this.channel instanceof DatagramChannel) {
                DatagramChannel udpChannel = (DatagramChannel)this.channel;
                udpChannel.send(ByteBuffer.wrap("Yep\n".getBytes()), this.udpPeer);
            } else {
                ((WritableByteChannel)((Object)this.channel)).write(ByteBuffer.wrap("Yep\n".getBytes()));
            }
        } else if (cmdType.equals("udp-transmitter")) {
            this.setUpTransmitter(params);
        } else if (!cmdType.equals("")) {
            throw new UnsupportedOperationException("Unknown command [" + cmdType.length() + "]: '" + cmdType + "'");
        }
    }

    public void addCommandString(String byteBufferToString) {
        this.commandString = this.commandString + byteBufferToString;
    }

    public boolean processNextCommand() throws IOException {
        log.debug("Command line is: " + this.commandString);
        if (this.commandString.indexOf(NEWLINE) >= 0) {
            int pos = this.commandString.indexOf(NEWLINE);
            String cmd = this.commandString.substring(0, pos);
            this.commandString = this.commandString.substring(pos + 1);
            this.processCommand(cmd);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getMetricsLine() throws IOException {
        log.debug("Building metrics");
        StringBuffer res = new StringBuffer();
        SelectableChannel selectableChannel = this.channel;
        synchronized (selectableChannel) {
            for (int n = 0; n < this.metrics.length; ++n) {
                try {
                    this.metrics[n].getValue(res);
                }
                catch (Exception ex) {
                    log.error("Error getting metric", (Throwable)ex);
                }
                res.append(TAB);
            }
        }
        res.append(NEWLINE);
        log.debug("Metrics line: " + res.toString());
        return ByteBuffer.wrap(res.toString().getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUpMetrics(String[] params) throws IOException {
        SelectableChannel selectableChannel = this.channel;
        synchronized (selectableChannel) {
            this.metrics = new AbstractPerfMonMetric[params.length];
            String metricParams = "";
            for (int n = 0; n < params.length; ++n) {
                String metricType = params[n];
                if (metricType.indexOf(DVOETOCHIE) >= 0) {
                    metricParams = metricType.substring(metricType.indexOf(DVOETOCHIE) + 1).trim();
                    metricType = metricType.substring(0, metricType.indexOf(DVOETOCHIE)).trim();
                }
                this.metrics[n] = AbstractPerfMonMetric.createMetric(metricType, metricParams, this.sigarProxy);
            }
        }
    }

    public boolean isStarted() {
        return this.metrics.length > 0;
    }

    private void setUpTransmitter(String params) throws IOException {
        log.info("Starting UDP transmitter for: " + params);
        if (params.indexOf(DVOETOCHIE) < 0) {
            throw new IllegalArgumentException("Wrong syntax for udp-transmitter command: " + params);
        }
        String transmitToAddr = params.substring(0, params.indexOf(DVOETOCHIE)).trim();
        if ((params = params.substring(params.indexOf(DVOETOCHIE) + 1).trim()).indexOf(DVOETOCHIE) < 0) {
            throw new IllegalArgumentException("Wrong syntax for udp-transmitter command: " + params);
        }
        int transmitToPort = Integer.parseInt(params.substring(0, params.indexOf(DVOETOCHIE)).trim());
        params = params.substring(params.indexOf(DVOETOCHIE) + 1).trim();
        this.setUpMetrics(params.split(TAB));
        DatagramChannel transmitter = DatagramChannel.open();
        InetSocketAddress addr = new InetSocketAddress(transmitToAddr, transmitToPort);
        transmitter.connect(addr);
        transmitter.configureBlocking(false);
        this.controller.registerWritingChannel(transmitter, this);
        this.controller.connectUDPClient(addr, transmitter, this);
    }
}

