/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mp4;

import java.io.Serializable;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tika.metadata.Metadata;

class ISO6709Extractor
implements Serializable {
    private static final Pattern ISO6709_PATTERN = Pattern.compile("\\A([-+])(\\d{2,6})(\\.\\d+)?([-+])(\\d{3,7})(\\.\\d+)?");

    ISO6709Extractor() {
    }

    public void extract(String s, Metadata m) {
        if (s == null) {
            return;
        }
        Matcher matcher = ISO6709_PATTERN.matcher(s);
        if (matcher.find()) {
            String lat = this.getLat(matcher.group(1), matcher.group(2), matcher.group(3));
            String lng = this.getLng(matcher.group(4), matcher.group(5), matcher.group(6));
            m.set(Metadata.LATITUDE, lat);
            m.set(Metadata.LONGITUDE, lng);
        }
    }

    private String getLng(String sign, String integer, String flot) {
        String flotNormed;
        String string = flotNormed = flot == null ? "" : flot;
        if (integer.length() == 3) {
            return sign + integer + flotNormed;
        }
        if (integer.length() == 5) {
            return this.calcDecimalDegrees(sign, integer.substring(0, 3), integer.substring(3, 5) + flotNormed);
        }
        if (integer.length() == 7) {
            return this.calcDecimalDegrees(sign, integer.substring(0, 3), integer.substring(3, 5), integer.substring(5, 7) + flotNormed);
        }
        return "";
    }

    private String getLat(String sign, String integer, String flot) {
        String flotNormed;
        String string = flotNormed = flot == null ? "" : flot;
        if (integer.length() == 2) {
            return sign + integer + flotNormed;
        }
        if (integer.length() == 4) {
            return this.calcDecimalDegrees(sign, integer.substring(0, 2), integer.substring(2, 4) + flotNormed);
        }
        if (integer.length() == 6) {
            return this.calcDecimalDegrees(sign, integer.substring(0, 2), integer.substring(2, 4), integer.substring(4, 6) + flotNormed);
        }
        return "";
    }

    private String calcDecimalDegrees(String sign, String degrees, String minutes) {
        double d = Integer.parseInt(degrees);
        return sign + String.format(Locale.ROOT, "%.8f", d += Double.parseDouble(minutes) / 60.0);
    }

    private String calcDecimalDegrees(String sign, String degrees, String minutes, String seconds) {
        double d = Integer.parseInt(degrees);
        d += Double.parseDouble(minutes) / 60.0;
        return sign + String.format(Locale.ROOT, "%.8f", d += Double.parseDouble(seconds) / 3600.0);
    }
}

