/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml.xwpf.ml2006;

import java.util.HashMap;
import java.util.Map;
import org.apache.poi.xwpf.usermodel.XWPFRelation;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.OfficeParserConfig;
import org.apache.tika.parser.microsoft.ooxml.xwpf.ml2006.BinaryDataHandler;
import org.apache.tika.parser.microsoft.ooxml.xwpf.ml2006.CorePropertiesHandler;
import org.apache.tika.parser.microsoft.ooxml.xwpf.ml2006.ExtendedPropertiesHandler;
import org.apache.tika.parser.microsoft.ooxml.xwpf.ml2006.PartHandler;
import org.apache.tika.parser.microsoft.ooxml.xwpf.ml2006.RelationshipsHandler;
import org.apache.tika.parser.microsoft.ooxml.xwpf.ml2006.RelationshipsManager;
import org.apache.tika.parser.microsoft.ooxml.xwpf.ml2006.WordAndPowerPointTextPartHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class Word2006MLDocHandler
extends DefaultHandler {
    static final String PKG_NS = "http://schemas.microsoft.com/office/2006/xmlPackage";
    private final XHTMLContentHandler xhtml;
    private final Metadata metadata;
    private final ParseContext parseContext;
    private final Map<String, PartHandler> partHandlers = new HashMap<String, PartHandler>();
    private final BinaryDataHandler binaryDataHandler;
    private final RelationshipsManager relationshipsManager = new RelationshipsManager();
    private PartHandler currentPartHandler = null;

    public Word2006MLDocHandler(XHTMLContentHandler xhtml, Metadata metadata, ParseContext context) {
        this.xhtml = xhtml;
        this.metadata = metadata;
        this.parseContext = context;
        OfficeParserConfig officeParserConfig = (OfficeParserConfig)context.get(OfficeParserConfig.class);
        this.addPartHandler(new RelationshipsHandler(this.relationshipsManager));
        this.addPartHandler(new WordAndPowerPointTextPartHandler(XWPFRelation.DOCUMENT.getContentType(), xhtml, this.relationshipsManager, officeParserConfig));
        this.addPartHandler(new WordAndPowerPointTextPartHandler(XWPFRelation.FOOTNOTE.getContentType(), xhtml, this.relationshipsManager, officeParserConfig));
        this.addPartHandler(new WordAndPowerPointTextPartHandler("application/vnd.openxmlformats-officedocument.wordprocessingml.endnotes+xml", xhtml, this.relationshipsManager, officeParserConfig));
        this.addPartHandler(new WordAndPowerPointTextPartHandler(XWPFRelation.HEADER.getContentType(), xhtml, this.relationshipsManager, officeParserConfig));
        this.addPartHandler(new WordAndPowerPointTextPartHandler(XWPFRelation.FOOTER.getContentType(), xhtml, this.relationshipsManager, officeParserConfig));
        this.addPartHandler(new WordAndPowerPointTextPartHandler("application/vnd.openxmlformats-officedocument.wordprocessingml.comments+xml", xhtml, this.relationshipsManager, officeParserConfig));
        this.addPartHandler(new WordAndPowerPointTextPartHandler("application/vnd.openxmlformats-officedocument.wordprocessingml.footnotes+xml", xhtml, this.relationshipsManager, officeParserConfig));
        this.addPartHandler(new WordAndPowerPointTextPartHandler("application/vnd.openxmlformats-officedocument.wordprocessingml.document.glossary+xml", xhtml, this.relationshipsManager, officeParserConfig));
        this.addPartHandler(new CorePropertiesHandler(metadata));
        this.addPartHandler(new ExtendedPropertiesHandler(metadata));
        this.binaryDataHandler = new BinaryDataHandler(xhtml, metadata, context);
    }

    private void addPartHandler(PartHandler partHandler) {
        this.partHandlers.put(partHandler.getContentType(), partHandler);
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (uri.equals(PKG_NS) && localName.equals("part")) {
            String name = atts.getValue(PKG_NS, "name");
            String contentType = atts.getValue(PKG_NS, "contentType");
            this.currentPartHandler = this.partHandlers.get(contentType);
            if (this.currentPartHandler == null) {
                this.currentPartHandler = this.binaryDataHandler;
            }
            if (this.currentPartHandler != null) {
                this.currentPartHandler.setName(name);
            }
        } else if (this.currentPartHandler != null) {
            this.currentPartHandler.startElement(uri, localName, qName, atts);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (uri.equals(PKG_NS) && localName.equals("part")) {
            if (this.currentPartHandler != null) {
                try {
                    this.currentPartHandler.endPart();
                }
                catch (TikaException e) {
                    throw new SAXException((Exception)((Object)e));
                }
            }
            this.currentPartHandler = null;
        } else if (this.currentPartHandler != null) {
            this.currentPartHandler.endElement(uri, localName, qName);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentPartHandler != null) {
            this.currentPartHandler.characters(ch, start, length);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.currentPartHandler != null) {
            this.currentPartHandler.characters(ch, start, length);
        }
    }
}

