/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;

public class IntSum
extends AbstractFunction {
    private static final List<String> desc = new ArrayList<String>();
    private static final String KEY = "__intSum";
    private Object[] values;

    public String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        JMeterVariables vars = this.getVariables();
        int sum = 0;
        String varName = ((CompoundVariable)this.values[this.values.length - 1]).execute().trim();
        for (int i = 0; i < this.values.length - 1; ++i) {
            sum += Integer.parseInt(((CompoundVariable)this.values[i]).execute());
        }
        try {
            sum += Integer.parseInt(varName);
            varName = null;
        }
        catch (NumberFormatException i) {
            // empty catch block
        }
        String totalString = Integer.toString(sum);
        if (vars != null && varName != null) {
            vars.put(varName.trim(), totalString);
        }
        return totalString;
    }

    public void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkMinParameterCount(parameters, 2);
        this.values = parameters.toArray();
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    static {
        desc.add(JMeterUtils.getResString((String)"intsum_param_1"));
        desc.add(JMeterUtils.getResString((String)"intsum_param_2"));
        desc.add(JMeterUtils.getResString((String)"function_name_paropt"));
    }
}

