/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigestEncodeFunction
extends AbstractFunction {
    private static final Logger log = LoggerFactory.getLogger(DigestEncodeFunction.class);
    private static final List<String> desc = new ArrayList<String>();
    private static final String KEY = "__digest";
    private static final int MIN_PARAMETER_COUNT = 2;
    private static final int MAX_PARAMETER_COUNT = 5;
    private CompoundVariable[] values;

    public String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        String digestAlgorithm = this.values[0].execute();
        String stringToEncode = this.values[1].execute();
        String salt = this.values.length > 2 ? this.values[2].execute() : null;
        String encodedString = null;
        try {
            MessageDigest md = MessageDigest.getInstance(digestAlgorithm);
            md.update(stringToEncode.getBytes(StandardCharsets.UTF_8));
            if (StringUtils.isNotEmpty((CharSequence)salt)) {
                md.update(salt.getBytes(StandardCharsets.UTF_8));
            }
            byte[] bytes = md.digest();
            encodedString = this.uppercase(Hex.encodeHexString((byte[])bytes), this.values, 3);
            this.addVariableValue(encodedString, this.values, 4);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Error calling {} function with value {}, digest algorithm {}, salt {}, ", new Object[]{KEY, stringToEncode, digestAlgorithm, salt, e});
        }
        return encodedString;
    }

    private String uppercase(String encodedString, CompoundVariable[] values, int index) {
        String shouldUpperCase;
        String string = shouldUpperCase = values.length > index ? values[index].execute() : null;
        if (Boolean.parseBoolean(shouldUpperCase)) {
            return encodedString.toUpperCase();
        }
        return encodedString;
    }

    public void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 2, 5);
        this.values = parameters.toArray(new CompoundVariable[parameters.size()]);
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    static {
        desc.add(JMeterUtils.getResString((String)"algorithm_string"));
        desc.add(JMeterUtils.getResString((String)"sha_string"));
        desc.add(JMeterUtils.getResString((String)"salt_string"));
        desc.add(JMeterUtils.getResString((String)"upper_case"));
        desc.add(JMeterUtils.getResString((String)"function_name_paropt"));
    }
}

