/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.platform.windows;

import com.github.weisj.darklaf.platform.windows.JNIThemeInfoWindows;
import com.github.weisj.darklaf.platform.windows.WindowsThemePreferenceProvider;
import com.github.weisj.darklaf.util.LogUtil;
import java.util.logging.Logger;

public class WindowsPreferenceMonitor {
    private static final Logger LOGGER = LogUtil.getLogger(WindowsThemePreferenceProvider.class);
    private final WindowsThemePreferenceProvider preferenceProvider;
    private boolean darkMode;
    private boolean highContrast;
    private long fontScaleFactor;
    private long eventHandler;
    private int color;
    private boolean running;

    public WindowsPreferenceMonitor(WindowsThemePreferenceProvider preferenceProvider) {
        this.preferenceProvider = preferenceProvider;
    }

    private void onNotification() {
        boolean newDark = JNIThemeInfoWindows.isDarkThemeEnabled();
        boolean newHighContrast = JNIThemeInfoWindows.isHighContrastEnabled();
        long newFotScale = JNIThemeInfoWindows.getFontScaleFactor();
        int newColor = JNIThemeInfoWindows.getAccentColor();
        if (this.darkMode != newDark || this.color != newColor || this.fontScaleFactor != newFotScale || this.highContrast != newHighContrast) {
            this.darkMode = newDark;
            this.fontScaleFactor = newFotScale;
            this.highContrast = newHighContrast;
            this.color = newColor;
            this.preferenceProvider.reportPreferenceChange(this.highContrast, this.darkMode, this.fontScaleFactor, this.color);
        }
    }

    private void start() {
        this.darkMode = JNIThemeInfoWindows.isDarkThemeEnabled();
        this.highContrast = JNIThemeInfoWindows.isHighContrastEnabled();
        this.fontScaleFactor = JNIThemeInfoWindows.getFontScaleFactor();
        this.color = JNIThemeInfoWindows.getAccentColor();
        this.eventHandler = JNIThemeInfoWindows.createEventHandler(this::onNotification);
        if (this.eventHandler == 0L) {
            LOGGER.severe("Could not create notification listener. Monitoring will not be started");
            return;
        }
        this.running = true;
        LOGGER.info("Started preference monitoring.");
    }

    private void stop() {
        if (!this.running) {
            return;
        }
        LOGGER.info("Stopped preference monitoring.");
        this.running = false;
        JNIThemeInfoWindows.deleteEventHandler(this.eventHandler);
    }

    public void setRunning(boolean running) {
        if (running == this.isRunning()) {
            return;
        }
        if (running) {
            this.start();
        } else {
            this.stop();
        }
    }

    public boolean isRunning() {
        return this.running;
    }
}

