/*
 * Decompiled with CFR 0.152.
 */
package jodd.buffer;

import java.util.Arrays;

public class FastFloatBuffer {
    private float[] buffer;
    private int offset;

    public FastFloatBuffer() {
        this.buffer = new float[64];
    }

    public FastFloatBuffer(int size) {
        this.buffer = new float[size];
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.buffer.length;
        int newCapacity = oldCapacity << 1;
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity + 512;
        }
        this.buffer = Arrays.copyOf(this.buffer, newCapacity);
    }

    public void append(float element) {
        if (this.offset - this.buffer.length >= 0) {
            this.grow(this.offset);
        }
        this.buffer[this.offset++] = element;
    }

    public FastFloatBuffer append(float[] array, int off, int len) {
        if (this.offset + len - this.buffer.length > 0) {
            this.grow(this.offset + len);
        }
        System.arraycopy(array, off, this.buffer, this.offset, len);
        this.offset += len;
        return this;
    }

    public FastFloatBuffer append(float[] array) {
        return this.append(array, 0, array.length);
    }

    public FastFloatBuffer append(FastFloatBuffer buff) {
        if (buff.offset == 0) {
            return this;
        }
        this.append(buff.buffer, 0, buff.offset);
        return this;
    }

    public int size() {
        return this.offset;
    }

    public boolean isEmpty() {
        return this.offset == 0;
    }

    public void clear() {
        this.offset = 0;
    }

    public float[] toArray() {
        return Arrays.copyOf(this.buffer, this.offset);
    }

    public float[] toArray(int start, int len) {
        float[] array = new float[len];
        if (len == 0) {
            return array;
        }
        System.arraycopy(this.buffer, start, array, 0, len);
        return array;
    }

    public float get(int index) {
        if (index >= this.offset) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffer[index];
    }
}

