/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.axisChart.customRenderers.axisValue.renderers;

import java.awt.Font;
import java.text.NumberFormat;
import org.jCharts.axisChart.AxisChart;
import org.jCharts.axisChart.customRenderers.axisValue.AxisValueRenderEvent;
import org.jCharts.axisChart.customRenderers.axisValue.PostAxisValueRenderListener;
import org.jCharts.axisChart.customRenderers.axisValue.renderers.ValueLabelPosition;
import org.jCharts.chartData.interfaces.IAxisChartDataSet;
import org.jCharts.chartText.NumericTagGroup;
import org.jCharts.chartText.TextTag;
import org.jCharts.properties.util.ChartFont;

public class ValueLabelRenderer
implements PostAxisValueRenderListener {
    private NumberFormat numberFormat;
    private ChartFont valueChartFont = ChartFont.DEFAULT_AXIS_VALUE;
    private Font derivedFont;
    private boolean isLabelVertical = false;
    private ValueLabelPosition valueLabelPosition = ValueLabelPosition.ON_TOP;
    private int pixelValuePadding = 4;

    public ValueLabelRenderer(boolean bl, boolean bl2, int n) {
        this.numberFormat = NumericTagGroup.getNumberFormatInstance(bl, false, bl2, n);
    }

    public ValueLabelRenderer(boolean bl, boolean bl2, boolean bl3, int n) {
        this.numberFormat = NumericTagGroup.getNumberFormatInstance(bl, bl2, bl3, n);
    }

    public void setValueLabelPosition(ValueLabelPosition valueLabelPosition) {
        this.valueLabelPosition = valueLabelPosition;
    }

    public void setValueChartFont(ChartFont chartFont) {
        this.valueChartFont = chartFont;
    }

    public void useVerticalLabels(boolean bl) {
        this.isLabelVertical = bl;
        if (this.isLabelVertical) {
            this.derivedFont = this.valueChartFont.deriveFont();
        }
    }

    public void setPixelValuePadding(int n) {
        this.pixelValuePadding = n;
    }

    public void postRender(AxisValueRenderEvent axisValueRenderEvent) {
        float f;
        float f2;
        TextTag textTag;
        AxisChart axisChart = (AxisChart)axisValueRenderEvent.getSource();
        if (axisValueRenderEvent.getiAxisPlotDataSet() instanceof IAxisChartDataSet) {
            IAxisChartDataSet iAxisChartDataSet = (IAxisChartDataSet)axisValueRenderEvent.getiAxisPlotDataSet();
            double d = iAxisChartDataSet.getValue(axisValueRenderEvent.getDataSetIndex(), axisValueRenderEvent.getValueIndex());
            textTag = new TextTag(this.numberFormat.format(d), this.valueChartFont.getFont(), this.derivedFont, axisValueRenderEvent.getFontRenderContext());
            if (axisChart.getAxisProperties().isPlotHorizontal()) {
                f2 = this.calculateXHorizontalPlot(axisValueRenderEvent, textTag, d < 0.0);
                f = this.calculateYHorizontalPlot(axisValueRenderEvent, textTag);
            } else {
                f2 = this.calculateXVerticalPlot(axisValueRenderEvent, textTag);
                f = this.calculateYVerticalPlot(axisValueRenderEvent, textTag, d < 0.0);
            }
        } else {
            Object var3_6 = null;
            float f3 = 100.0f;
            float f4 = 100.0f;
            throw new RuntimeException("Axis Values not yet implemented for this type of chart.");
        }
        textTag.setXPosition(f2);
        textTag.setYPosition(f);
        textTag.render(axisValueRenderEvent.getGraphics2D(), this.valueChartFont.getPaint());
    }

    private float calculateXVerticalPlot(AxisValueRenderEvent axisValueRenderEvent, TextTag textTag) {
        float f = axisValueRenderEvent.getValueX();
        f = this.isLabelVertical ? (f += textTag.getFontDescent()) : (f -= textTag.getWidth() / 2.0f);
        return f;
    }

    private float calculateYHorizontalPlot(AxisValueRenderEvent axisValueRenderEvent, TextTag textTag) {
        float f = axisValueRenderEvent.getValueY();
        f = this.isLabelVertical ? (f += textTag.getWidth() / 2.0f) : (f += textTag.getFontDescent());
        return f;
    }

    private float calculateXHorizontalPlot(AxisValueRenderEvent axisValueRenderEvent, TextTag textTag, boolean bl) {
        float f = axisValueRenderEvent.getValueX();
        if (this.valueLabelPosition.equals(ValueLabelPosition.ON_TOP)) {
            if (bl) {
                f -= this.isLabelVertical ? 0.0f : textTag.getWidth();
                f -= (float)this.pixelValuePadding;
            } else {
                f += this.isLabelVertical ? textTag.getFontAscent() : 0.0f;
                f += (float)this.pixelValuePadding;
            }
        } else if (this.valueLabelPosition.equals(ValueLabelPosition.AT_TOP)) {
            if (bl) {
                f += this.isLabelVertical ? textTag.getFontAscent() : 0.0f;
                f += (float)this.pixelValuePadding;
            } else {
                f -= this.isLabelVertical ? textTag.getFontDescent() : textTag.getWidth();
                f -= (float)this.pixelValuePadding;
            }
        } else if (this.valueLabelPosition.equals(ValueLabelPosition.ABOVE_ZERO_LINE)) {
            f = axisValueRenderEvent.getZeroLineCoordinate();
            if (bl) {
                f += this.isLabelVertical ? textTag.getFontAscent() : 0.0f;
                f += (float)this.pixelValuePadding;
            } else {
                f -= this.isLabelVertical ? textTag.getFontDescent() : textTag.getWidth();
                f -= (float)this.pixelValuePadding;
            }
        } else if (this.valueLabelPosition.equals(ValueLabelPosition.AXIS_TOP)) {
            f = axisValueRenderEvent.getTotalItemAxisArea().x + axisValueRenderEvent.getTotalItemAxisArea().width;
            f -= this.isLabelVertical ? 0.0f : textTag.getWidth();
            f -= (float)this.pixelValuePadding;
        } else if (this.valueLabelPosition.equals(ValueLabelPosition.AXIS_BOTTOM)) {
            f = axisValueRenderEvent.getTotalItemAxisArea().x;
            f += this.isLabelVertical ? textTag.getFontAscent() : 0.0f;
            f += (float)this.pixelValuePadding;
        }
        if (f + textTag.getWidth() > axisValueRenderEvent.getTotalItemAxisArea().x + axisValueRenderEvent.getTotalItemAxisArea().width) {
            f = axisValueRenderEvent.getTotalItemAxisArea().x + axisValueRenderEvent.getTotalItemAxisArea().width;
            f -= textTag.getWidth();
            f -= (float)this.pixelValuePadding;
        } else if (f < axisValueRenderEvent.getTotalItemAxisArea().x) {
            f = axisValueRenderEvent.getTotalItemAxisArea().x;
            f += (float)this.pixelValuePadding;
        }
        return f;
    }

    private float calculateYVerticalPlot(AxisValueRenderEvent axisValueRenderEvent, TextTag textTag, boolean bl) {
        float f = axisValueRenderEvent.getValueY();
        if (this.valueLabelPosition.equals(ValueLabelPosition.ON_TOP)) {
            if (bl) {
                f += this.isLabelVertical ? textTag.getWidth() : textTag.getHeight();
                f += (float)this.pixelValuePadding;
            } else {
                f -= (float)this.pixelValuePadding;
            }
        } else if (this.valueLabelPosition.equals(ValueLabelPosition.AT_TOP)) {
            if (bl) {
                f -= (float)this.pixelValuePadding;
            } else {
                f += this.isLabelVertical ? textTag.getWidth() : textTag.getHeight();
                f += (float)this.pixelValuePadding;
            }
        } else if (this.valueLabelPosition.equals(ValueLabelPosition.ABOVE_ZERO_LINE)) {
            f = axisValueRenderEvent.getZeroLineCoordinate();
            if (bl) {
                f -= (float)this.pixelValuePadding;
            } else {
                f += this.isLabelVertical ? textTag.getWidth() : textTag.getHeight();
                f += (float)this.pixelValuePadding;
            }
        } else if (this.valueLabelPosition.equals(ValueLabelPosition.AXIS_TOP)) {
            f = axisValueRenderEvent.getTotalItemAxisArea().y;
            f += this.isLabelVertical ? textTag.getWidth() : textTag.getHeight();
            f += (float)this.pixelValuePadding;
        } else if (this.valueLabelPosition.equals(ValueLabelPosition.AXIS_BOTTOM)) {
            f = axisValueRenderEvent.getTotalItemAxisArea().y + axisValueRenderEvent.getTotalItemAxisArea().height;
            f -= (float)this.pixelValuePadding;
        }
        if (this.isLabelVertical) {
            if (f - textTag.getWidth() < axisValueRenderEvent.getTotalItemAxisArea().y) {
                f = axisValueRenderEvent.getTotalItemAxisArea().y;
                f += textTag.getWidth();
                f += (float)this.pixelValuePadding;
            } else if (f > axisValueRenderEvent.getTotalItemAxisArea().y + axisValueRenderEvent.getTotalItemAxisArea().height) {
                f = axisValueRenderEvent.getTotalItemAxisArea().y + axisValueRenderEvent.getTotalItemAxisArea().height;
                f -= (float)this.pixelValuePadding;
            }
        } else if (f - textTag.getHeight() < axisValueRenderEvent.getTotalItemAxisArea().y) {
            f = axisValueRenderEvent.getTotalItemAxisArea().y;
            f += textTag.getHeight();
            f += (float)this.pixelValuePadding;
        } else if (f > axisValueRenderEvent.getTotalItemAxisArea().y + axisValueRenderEvent.getTotalItemAxisArea().height) {
            f = axisValueRenderEvent.getTotalItemAxisArea().y + axisValueRenderEvent.getTotalItemAxisArea().height;
            f -= (float)this.pixelValuePadding;
        }
        return f;
    }
}

