/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.task;

import com.github.weisj.darklaf.color.DarkColorModelHSB;
import com.github.weisj.darklaf.color.DarkColorModelHSL;
import com.github.weisj.darklaf.task.ColorAdjustmentTask;
import com.github.weisj.darklaf.theme.Theme;
import com.github.weisj.darklaf.theme.info.AccentColorRule;
import com.github.weisj.darklaf.uiresource.DarkColorUIResource;
import com.github.weisj.darklaf.util.ColorUtil;
import com.github.weisj.darklaf.util.Pair;
import java.awt.Color;
import java.util.List;
import java.util.Properties;
import javax.swing.plaf.ColorUIResource;

public class ForegroundColorGenerationTask
extends ColorAdjustmentTask {
    private static final String FOREGROUND_LIST_KEY = "selectionForeground.propertyList";
    private static final String ACCENT_LIST_KEY = "accentForeground.propertyList";
    private static final double MIN_FOREGROUND_DIFFERENCE = 0.5;

    @Override
    protected void beforeTask(Theme currentTheme, Properties properties) {
        super.beforeTask(currentTheme, properties);
        DEFAULTS.putAll(properties);
    }

    @Override
    protected void runTask(Theme currentTheme, Properties properties) {
        Properties props = currentTheme.loadPropertyFile("accents", true);
        AccentColorRule accentColorRule = currentTheme.getAccentColorRule();
        if (accentColorRule.getAccentColor() != null && currentTheme.supportsCustomAccentColor()) {
            this.adjust(ACCENT_LIST_KEY, props, list -> this.adjustForegroundList((List<?>)list, properties));
        }
        if (accentColorRule.getSelectionColor() != null && currentTheme.supportsCustomSelectionColor()) {
            this.adjust(FOREGROUND_LIST_KEY, props, list -> this.adjustForegroundList((List<?>)list, properties));
        }
    }

    private void adjustForegroundList(List<?> list, Properties properties) {
        list.stream().filter(o -> o instanceof Pair).map(Pair.class::cast).filter(p -> p.getFirst() instanceof Color).forEach(p -> properties.put(p.getSecond(), ForegroundColorGenerationTask.makeForeground((Color)p.getFirst())));
    }

    public static ColorUIResource makeForeground(Color bg) {
        return ForegroundColorGenerationTask.makeForeground(bg, 0.5);
    }

    public static ColorUIResource makeForeground(Color bg, double minimumBrightnessDifference) {
        double[] hsbBG = DarkColorModelHSB.RGBtoHSBValues(bg.getRed(), bg.getGreen(), bg.getBlue());
        Color fg = DarkColorModelHSB.getColorFromHSBValues(hsbBG[0], 0.0, 1.0 - hsbBG[2]);
        return ForegroundColorGenerationTask.makeAdjustedForeground(fg, bg, Bias.getBackground(), minimumBrightnessDifference);
    }

    public static ColorUIResource makeAdjustedForeground(Color fg, Color bg, double minimumBrightnessDifference) {
        return ForegroundColorGenerationTask.makeAdjustedForeground(fg, bg, Bias.getBackground(), minimumBrightnessDifference);
    }

    public static ColorUIResource makeAdjustedForeground(Color fg, Color bg, Bias bias, double minimumBrightnessDifference) {
        Bias b;
        double[] hslFG = DarkColorModelHSL.RGBtoHSLValues(fg.getRed(), fg.getGreen(), fg.getBlue());
        double[] hslBG = DarkColorModelHSL.RGBtoHSLValues(bg.getRed(), bg.getGreen(), bg.getBlue());
        double bgBrightness = hslBG[2];
        double fgBrightness = hslFG[2];
        Bias bias2 = b = bias != null ? bias : Bias.getBackground();
        if (b == Bias.BACKGROUND) {
            double bgBright = ColorUtil.getLuminance((Color)bg);
            b = bgBright <= b.threshold ? Bias.WHITE : Bias.BLACK;
        }
        double bright1 = fgBrightness > bgBrightness && fgBrightness - bgBrightness >= minimumBrightnessDifference ? hslFG[2] : Math.min(bgBrightness + minimumBrightnessDifference, 1.0);
        double bright2 = fgBrightness < bgBrightness && bgBrightness - fgBrightness >= minimumBrightnessDifference ? hslFG[2] : Math.max(bgBrightness - minimumBrightnessDifference, 0.0);
        double brightness = b == Bias.WHITE ? bright1 : bright2;
        return new DarkColorUIResource(DarkColorModelHSL.getColorFromHSLValues(hslFG[0], hslFG[1], brightness));
    }

    public static enum Bias {
        BACKGROUND,
        WHITE,
        BLACK;

        private double threshold = 0.5;

        public static Bias getBackground() {
            return Bias.getBackground(0.5);
        }

        public static Bias getBackground(double threshold) {
            BACKGROUND.setThreshold(threshold);
            return BACKGROUND;
        }

        public void setThreshold(double threshold) {
            this.threshold = threshold;
        }
    }
}

