/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.utils.base64;

public class OPENPGPKEYRecord
extends Record {
    private static final long serialVersionUID = -1277262990243423062L;
    private byte[] cert;

    OPENPGPKEYRecord() {
    }

    Record getObject() {
        return new OPENPGPKEYRecord();
    }

    public OPENPGPKEYRecord(Name name, int dclass, long ttl, byte[] cert) {
        super(name, 61, dclass, ttl);
        this.cert = cert;
    }

    void rrFromWire(DNSInput in) throws IOException {
        this.cert = in.readByteArray();
    }

    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.cert = st.getBase64();
    }

    String rrToString() {
        StringBuffer sb = new StringBuffer();
        if (this.cert != null) {
            if (Options.check("multiline")) {
                sb.append("(\n");
                sb.append(base64.formatString(this.cert, 64, "\t", true));
            } else {
                sb.append(base64.toString(this.cert));
            }
        }
        return sb.toString();
    }

    public byte[] getCert() {
        return this.cert;
    }

    void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        out.writeByteArray(this.cert);
    }
}

