/*
 * Decompiled with CFR 0.152.
 */
package org.jmeterplugins.repository.plugins;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.util.EscapeDialog;
import org.apache.jorphan.gui.ComponentUtil;
import org.jmeterplugins.repository.GenericCallback;
import org.jmeterplugins.repository.Plugin;
import org.jmeterplugins.repository.PluginIcon;
import org.jmeterplugins.repository.PluginManager;
import org.jmeterplugins.repository.PluginManagerDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuggestDialog
extends EscapeDialog
implements GenericCallback<String> {
    private static final Logger log = LoggerFactory.getLogger(SuggestDialog.class);
    private final PluginManager manager;
    private final JLabel titleLabel = new JLabel("");
    private final JLabel statusLabel = new JLabel("");

    public SuggestDialog(Frame parent, PluginManager manager, Set<Plugin> plugins, String testPlan) {
        super(parent, "JMeter Plugins Manager", true);
        this.setLocationRelativeTo(parent);
        this.manager = manager;
        this.init(plugins, testPlan);
    }

    private void init(Set<Plugin> plugins, String testPlan) {
        this.setLayout(new BorderLayout());
        this.setIconImage(PluginIcon.getPluginFrameIcon(this.manager.hasAnyUpdates(), (Window)((Object)this)));
        ComponentUtil.centerComponentInWindow((Component)((Object)this));
        JPanel mainPanel = new JPanel(new BorderLayout(0, 0));
        mainPanel.setBorder(PluginManagerDialog.SPACING);
        StringBuilder message = new StringBuilder("<html><p>Your test plan requires following plugins:</p><ul>");
        for (Plugin plugin : plugins) {
            message.append("<li>").append(plugin.getName()).append("</li>");
        }
        message.append("</ul>");
        message.append("<p></p>");
        message.append("<p>Plugins Manager can install it automatically. Following changes will be applied:</p>");
        message.append("</html>");
        this.titleLabel.setText(message.toString());
        mainPanel.add((Component)this.titleLabel, "North");
        mainPanel.add((Component)this.getDetailsPanel(), "Center");
        mainPanel.add((Component)this.getButtonsPanel(plugins, testPlan), "South");
        this.add(mainPanel, "Center");
        this.pack();
    }

    private JPanel getButtonsPanel(final Set<Plugin> plugins, final String testPlan) {
        final JButton btnYes = new JButton("Yes, install it");
        final JButton btnNo = new JButton("Cancel");
        final SuggestDialog dialog = this;
        btnYes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                btnYes.setEnabled(false);
                btnNo.setEnabled(false);
                new Thread(){

                    @Override
                    public void run() {
                        LinkedList<String> options = new LinkedList<String>();
                        options.add("-t");
                        options.add(testPlan);
                        SuggestDialog.this.manager.applyChanges(dialog, true, options);
                        SuggestDialog.this.dispose();
                        ActionRouter.getInstance().actionPerformed(new ActionEvent(this, 0, "exit"));
                    }
                }.start();
            }
        });
        btnNo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SuggestDialog.this.manager.togglePlugins(plugins, false);
                SuggestDialog.this.dispose();
            }
        });
        JPanel buttons = new JPanel(new FlowLayout());
        buttons.add(btnYes);
        buttons.add(btnNo);
        JPanel btnPanel = new JPanel(new BorderLayout());
        btnPanel.setBorder(PluginManagerDialog.SPACING);
        btnPanel.add((Component)buttons, "East");
        btnPanel.add((Component)this.statusLabel, "West");
        return btnPanel;
    }

    private JPanel getDetailsPanel() {
        JTextArea messageLabel = new JTextArea(this.manager.getChangesAsText());
        messageLabel.setEditable(false);
        JPanel messagePanel = new JPanel(new BorderLayout());
        messagePanel.setBorder(PluginManagerDialog.SPACING);
        messagePanel.add(new JScrollPane(messageLabel));
        return messagePanel;
    }

    @Override
    public void notify(final String s) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SuggestDialog.this.statusLabel.setText(s);
                SuggestDialog.this.repaint();
            }
        });
    }
}

