/*
 * Decompiled with CFR 0.152.
 */
package org.jmeterplugins.repository;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.file.AccessDeniedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.config.ConfigElement;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.engine.JMeterEngine;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.processor.PostProcessor;
import org.apache.jmeter.processor.PreProcessor;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.timers.Timer;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.reflect.ClassFinder;
import org.jmeterplugins.repository.ChangesMaker;
import org.jmeterplugins.repository.DependencyResolver;
import org.jmeterplugins.repository.GenericCallback;
import org.jmeterplugins.repository.JARSource;
import org.jmeterplugins.repository.JARSourceFilesystem;
import org.jmeterplugins.repository.JARSourceHTTP;
import org.jmeterplugins.repository.Library;
import org.jmeterplugins.repository.Plugin;
import org.jmeterplugins.repository.exception.DownloadException;
import org.jmeterplugins.repository.http.StatsReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginManager {
    private static final Logger log = LoggerFactory.getLogger(PluginManager.class);
    private static PluginManager staticManager = new PluginManager();
    private final JARSource jarSource;
    private boolean isSendRepoStats = true;
    protected Map<Plugin, Boolean> allPlugins = new HashMap<Plugin, Boolean>();

    public PluginManager() {
        String sysProp = System.getProperty("jpgc.repo.address", "https://jmeter-plugins.org/repo/");
        String jmProp = JMeterUtils.getPropDefault((String)"jpgc.repo.address", (String)sysProp);
        File jsonFile = new File(jmProp);
        this.jarSource = jsonFile.isFile() ? new JARSourceFilesystem(jsonFile) : new JARSourceHTTP(jmProp);
    }

    public boolean hasPlugins() {
        return this.allPlugins.size() > 0;
    }

    public synchronized void load() throws Throwable {
        PluginManager.detectJARConflicts();
        if (this.hasPlugins()) {
            return;
        }
        JSON json = this.jarSource.getRepo();
        if (!(json instanceof JSONArray)) {
            throw new RuntimeException("Result is not array");
        }
        for (Object elm : (JSONArray)json) {
            if (elm instanceof JSONObject) {
                Plugin plugin = Plugin.fromJSON((JSONObject)elm);
                if (plugin.getName().isEmpty()) {
                    log.debug("Skip empty name: " + plugin);
                    continue;
                }
                if (!plugin.isVirtual()) {
                    plugin.detectInstalled(this.getInstalledPlugins());
                }
                this.allPlugins.put(plugin, plugin.isInstalled());
                continue;
            }
            log.warn("Invalid array element: " + elm);
        }
        for (Plugin plugin : this.allPlugins.keySet()) {
            if (!plugin.isVirtual()) continue;
            plugin.detectInstalled(this.getInstalledPlugins());
            this.allPlugins.put(plugin, plugin.isInstalled());
        }
        if (this.isSendRepoStats && JMeterUtils.getPropDefault((String)"jpgc.repo.sendstats", (String)"true").equals("true")) {
            try {
                StatsReporter reporter = new StatsReporter(this.jarSource, this.getUsageStats());
                log.debug("Start sending repo stats");
                reporter.start();
            }
            catch (Exception e) {
                log.debug("Failed to report usage stats", (Throwable)e);
            }
        }
        log.info("Plugins Status: " + this.getAllPluginsStatusString());
    }

    private void checkRW() throws UnsupportedEncodingException, AccessDeniedException {
        File libext;
        String jarPath = Plugin.getJARPath(JMeterEngine.class.getCanonicalName());
        if (jarPath != null && !this.isWritable(libext = new File(URLDecoder.decode(jarPath, "UTF-8")).getParentFile())) {
            String msg = "Have no write access for JMeter directories, not possible to use Plugins Manager: ";
            throw new AccessDeniedException(msg + libext);
        }
    }

    private boolean isWritable(File path) {
        File sample = new File(path, "empty.txt");
        try {
            sample.createNewFile();
            sample.delete();
            return true;
        }
        catch (IOException e) {
            log.debug("Write check failed for " + path, (Throwable)e);
            return false;
        }
    }

    public void startModifications(Set<Plugin> delPlugins, Set<Plugin> installPlugins, Set<Library.InstallationInfo> installLibs, Set<String> libDeletions, boolean doRestart, LinkedList<String> additionalJMeterOptions) throws IOException {
        ChangesMaker maker = new ChangesMaker(this.allPlugins);
        File moveFile = maker.getMovementsFile(delPlugins, installPlugins, installLibs, libDeletions);
        File installFile = maker.getInstallFile(installPlugins, installLibs);
        File restartFile = doRestart ? maker.getRestartFile(additionalJMeterOptions) : null;
        ProcessBuilder builder = maker.getProcessBuilder(moveFile, installFile, restartFile);
        log.info("JAR Modifications log will be saved into: " + builder.redirectOutput().file().getPath());
        builder.start();
    }

    public void applyChanges(GenericCallback<String> statusChanged, boolean doRestart, LinkedList<String> additionalJMeterOptions) {
        try {
            this.checkRW();
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot apply changes: " + e.getMessage(), e);
        }
        DependencyResolver resolver = new DependencyResolver(this.allPlugins);
        Set<Plugin> additions = resolver.getAdditions();
        HashSet<Library.InstallationInfo> libInstalls = new HashSet<Library.InstallationInfo>();
        for (Map.Entry<String, String> entry : resolver.getLibAdditions().entrySet()) {
            try {
                JARSource.DownloadResult dwn = this.jarSource.getJAR(entry.getKey(), entry.getValue(), statusChanged);
                libInstalls.add(new Library.InstallationInfo(entry.getKey(), dwn.getTmpFile(), dwn.getFilename()));
            }
            catch (Throwable e) {
                String msg = "Failed to download " + entry.getKey();
                log.error(msg, e);
                statusChanged.notify(msg);
                throw new DownloadException("Failed to download library " + entry.getKey(), e);
            }
        }
        for (Plugin plugin : additions) {
            try {
                plugin.download(this.jarSource, statusChanged);
            }
            catch (IOException e) {
                String msg = "Failed to download " + plugin;
                log.error(msg, (Throwable)e);
                statusChanged.notify(msg);
                throw new DownloadException("Failed to download plugin " + plugin, e);
            }
        }
        if (doRestart) {
            log.info("Restarting JMeter...");
            statusChanged.notify("Restarting JMeter...");
        }
        HashSet<String> libDeletions = new HashSet<String>();
        for (String lib : resolver.getLibDeletions()) {
            libDeletions.add(Plugin.getLibInstallPath(lib));
        }
        this.modifierHook(resolver.getDeletions(), additions, libInstalls, libDeletions, doRestart, additionalJMeterOptions);
    }

    private void modifierHook(final Set<Plugin> deletions, final Set<Plugin> additions, final Set<Library.InstallationInfo> libInstalls, final Set<String> libDeletions, final boolean doRestart, final LinkedList<String> additionalJMeterOptions) {
        if (deletions.isEmpty() && additions.isEmpty() && libInstalls.isEmpty() && libDeletions.isEmpty()) {
            log.info("Finishing without changes");
        } else {
            log.info("Plugins manager will apply some modifications");
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        log.info("Starting JMeter Plugins modifications");
                        PluginManager.this.startModifications(deletions, additions, libInstalls, libDeletions, doRestart, additionalJMeterOptions);
                    }
                    catch (Exception e) {
                        log.warn("Failed to run plugin cleaner job", (Throwable)e);
                    }
                }
            });
        }
    }

    protected String[] getUsageStats() {
        ArrayList<String> data = new ArrayList<String>();
        data.add(JMeterUtils.getJMeterVersion());
        for (Plugin p : this.getInstalledPlugins()) {
            data.add(p.getID() + "=" + p.getInstalledVersion());
        }
        log.debug("Usage stats: " + data);
        return data.toArray(new String[0]);
    }

    public String getChangesAsText() {
        DependencyResolver resolver = new DependencyResolver(this.allPlugins);
        StringBuilder text = new StringBuilder();
        for (Plugin plugin : resolver.getDeletions()) {
            text.append("Uninstall plugin: ").append(plugin).append(" ").append(plugin.getInstalledVersion()).append("\n");
        }
        for (String string : resolver.getLibDeletions()) {
            text.append("Uninstall library: ").append(string).append("\n");
        }
        for (String string : resolver.getLibAdditions().keySet()) {
            text.append("Install library: ").append(string).append("\n");
        }
        for (Plugin plugin : resolver.getAdditions()) {
            text.append("Install plugin: ").append(plugin).append(" ").append(plugin.getCandidateVersion()).append("\n");
        }
        return text.toString();
    }

    public Set<Plugin> getInstalledPlugins() {
        TreeSet<Plugin> result = new TreeSet<Plugin>(new PluginComparator());
        for (Plugin plugin : this.allPlugins.keySet()) {
            if (!plugin.isInstalled()) continue;
            result.add(plugin);
        }
        return result;
    }

    public static Set<Plugin> getInstalledPlugins(Map<Plugin, Boolean> allPlugins) {
        HashSet<Plugin> result = new HashSet<Plugin>();
        for (Plugin plugin : allPlugins.keySet()) {
            if (!plugin.isInstalled()) continue;
            result.add(plugin);
        }
        return result;
    }

    public Set<Plugin> getAvailablePlugins() {
        TreeSet<Plugin> result = new TreeSet<Plugin>(new PluginComparator());
        for (Plugin plugin : this.allPlugins.keySet()) {
            if (plugin.isInstalled()) continue;
            result.add(plugin);
        }
        return result;
    }

    public Set<Plugin> getUpgradablePlugins() {
        TreeSet<Plugin> result = new TreeSet<Plugin>(new PluginComparator());
        for (Plugin plugin : this.allPlugins.keySet()) {
            if (!plugin.isUpgradable()) continue;
            result.add(plugin);
        }
        return result;
    }

    public void togglePlugins(Set<Plugin> pluginsToInstall, boolean isInstall) {
        for (Plugin plugin : pluginsToInstall) {
            this.toggleInstalled(plugin, isInstall);
        }
    }

    public void toggleInstalled(Plugin plugin, boolean cbState) {
        if (!cbState && !plugin.canUninstall()) {
            log.warn("Cannot uninstall plugin: " + plugin);
            cbState = true;
        }
        this.allPlugins.put(plugin, cbState);
    }

    public boolean hasAnyUpdates() {
        for (Plugin p : this.allPlugins.keySet()) {
            if (!p.isUpgradable()) continue;
            return true;
        }
        return false;
    }

    public Plugin getPluginByID(String key) {
        for (Plugin p : this.allPlugins.keySet()) {
            if (!p.getID().equals(key)) continue;
            return p;
        }
        throw new IllegalArgumentException("Plugin not found in repo: " + key);
    }

    public void setTimeout(int timeout) {
        this.jarSource.setTimeout(timeout);
    }

    public static PluginManager getStaticManager() {
        try {
            staticManager.load();
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to get plugin repositories", e);
        }
        return staticManager;
    }

    public static String getPluginStatus(String id) {
        PluginManager manager = PluginManager.getStaticManager();
        for (Plugin plugin : manager.allPlugins.keySet()) {
            if (!plugin.id.equals(id)) continue;
            return plugin.getInstalledVersion();
        }
        return null;
    }

    public static String getAllPluginsStatus() {
        PluginManager manager = PluginManager.getStaticManager();
        return manager.getAllPluginsStatusString();
    }

    private String getAllPluginsStatusString() {
        ArrayList<String> res = new ArrayList<String>();
        for (Plugin plugin : this.getInstalledPlugins()) {
            res.add(plugin.getID() + "=" + plugin.getInstalledVersion());
        }
        return Arrays.toString(res.toArray());
    }

    public static String getAvailablePluginsAsString() {
        PluginManager manager = PluginManager.getStaticManager();
        return manager.getAvailablePluginsString();
    }

    private String getAvailablePluginsString() {
        ArrayList<String> res = new ArrayList<String>();
        for (Plugin plugin : this.getAvailablePlugins()) {
            ArrayList<String> versions = new ArrayList<String>(plugin.getVersions());
            Collections.reverse(versions);
            res.add(plugin.getID() + "=" + Arrays.toString(versions.toArray()));
        }
        return Arrays.toString(res.toArray());
    }

    public static String getUpgradablePluginsAsString() {
        PluginManager manager = PluginManager.getStaticManager();
        return manager.getUpgradablePluginsString();
    }

    private String getUpgradablePluginsString() {
        ArrayList<String> res = new ArrayList<String>();
        for (Plugin plugin : this.getUpgradablePlugins()) {
            res.add(plugin.getID() + "=" + plugin.getMaxVersion());
        }
        return res.size() != 0 ? Arrays.toString(res.toArray()) : "There is nothing to update.";
    }

    public static void detectJARConflicts() {
        String[] paths = System.getProperty("java.class.path").split(File.pathSeparator);
        HashMap<String, String> jarNames = new HashMap<String, String>();
        String[] stringArray = paths;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String path;
            String name = path = stringArray[i];
            int start = path.lastIndexOf(File.separator);
            if (start > 0) {
                name = name.substring(start + 1);
            }
            if (path.endsWith(".jar")) {
                name = name.substring(0, name.length() - 4);
            }
            if (jarNames.containsKey(name = PluginManager.removeJARVersion(name))) {
                log.warn("Found JAR conflict: " + path + " and " + (String)jarNames.get(name));
            }
            jarNames.put(name, path);
        }
    }

    protected static String removeJARVersion(String path) {
        StringBuilder result = new StringBuilder();
        String[] data = path.split("-");
        for (int i = 0; i < data.length; ++i) {
            String ch = data[i];
            if (ch.isEmpty() || Character.isDigit(ch.charAt(0)) && i >= data.length - 1) continue;
            result.append(ch);
        }
        return result.toString();
    }

    public void logPluginComponents() {
        StringBuilder report = new StringBuilder("Plugin Components:\n");
        for (Plugin plugin : this.getInstalledPlugins()) {
            try {
                Class[] superClasses = new Class[]{Sampler.class, Controller.class, Timer.class, ConfigElement.class, PreProcessor.class, PostProcessor.class, Assertion.class, SampleListener.class, JMeterGUIComponent.class, TestBean.class};
                String[] searchPaths = new String[]{plugin.installedPath};
                List list = ClassFinder.findClassesThatExtend((String[])searchPaths, (Class[])superClasses);
                report.append(plugin.id).append("\n").append("\"componentClasses\":").append(JSONSerializer.toJSON(list.toArray()).toString()).append(",\n");
            }
            catch (Throwable e) {
                log.error("Failed to get classes", e);
            }
        }
        log.info(report.toString());
    }

    public boolean isSendRepoStats() {
        return this.isSendRepoStats;
    }

    public void setSendRepoStats(boolean sendRepoStats) {
        this.isSendRepoStats = sendRepoStats;
    }

    private class PluginComparator
    implements Comparator<Plugin> {
        private PluginComparator() {
        }

        @Override
        public int compare(Plugin o1, Plugin o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

