/*
 * Decompiled with CFR 0.152.
 */
package org.jmeterplugins.repository;

import com.github.weisj.darklaf.icons.IconLoader;
import java.awt.Image;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class PluginIcon {
    private static boolean SVG_AVAILABLE;
    private static boolean FRAME_ICON_API_AVAILABLE;

    public static Image getPluginFrameIcon(boolean hasUpdates, Window window) {
        if (FRAME_ICON_API_AVAILABLE) {
            return IconLoader.createFrameIcon((Icon)PluginIcon.getPluginsIcon(hasUpdates), (Window)window);
        }
        return PluginIcon.getPluginImageIcon(hasUpdates, false).getImage();
    }

    public static Icon getIcon22Px(boolean hasUpdates) {
        if (SVG_AVAILABLE) {
            return PluginIcon.getPluginsSVGIcon(hasUpdates, 22);
        }
        return PluginIcon.getPluginImageIcon(hasUpdates, true);
    }

    public static Icon getPluginsIcon(boolean hasUpdates) {
        if (SVG_AVAILABLE) {
            return PluginIcon.getPluginsSVGIcon(hasUpdates, 16);
        }
        return PluginIcon.getPluginImageIcon(hasUpdates, false);
    }

    private static Icon getPluginsSVGIcon(boolean hasUpdates, int size) {
        if (hasUpdates) {
            return IconLoader.get().getIcon("org/jmeterplugins/logoUpdate.svg", size, size);
        }
        return IconLoader.get().getIcon("org/jmeterplugins/logo.svg", size, size);
    }

    private static ImageIcon getPluginImageIcon(boolean hasUpdates, boolean large) {
        String path = "/org/jmeterplugins/logo";
        if (large) {
            path = path + "22";
        }
        if (hasUpdates) {
            path = path + "Update";
        }
        path = path + ".png";
        return new ImageIcon(PluginIcon.class.getResource(path));
    }

    static {
        try {
            Class.forName("com.github.weisj.darklaf.icons.IconLoader");
            SVG_AVAILABLE = true;
        }
        catch (ClassNotFoundException e) {
            SVG_AVAILABLE = false;
        }
        if (SVG_AVAILABLE) {
            try {
                IconLoader.class.getDeclaredMethod("createFrameIcon", Icon.class, Window.class);
                FRAME_ICON_API_AVAILABLE = true;
            }
            catch (NoSuchMethodException e) {
                FRAME_ICON_API_AVAILABLE = false;
            }
        }
    }
}

