/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.node;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.Expression;
import io.burt.jmespath.JmesPathType;
import io.burt.jmespath.node.Node;
import java.util.ArrayList;
import java.util.List;

public class ProjectionNode<T>
extends Node<T> {
    private final Expression<T> projection;

    public ProjectionNode(Adapter<T> runtime, Expression<T> projection) {
        super(runtime);
        this.projection = projection;
    }

    @Override
    public T search(T input) {
        if (this.runtime.typeOf(input) == JmesPathType.ARRAY) {
            List<T> inputList = this.runtime.toList(input);
            ArrayList<T> results = new ArrayList<T>(inputList.size());
            for (T inputItem : inputList) {
                T result = this.projection.search(inputItem);
                JmesPathType type = this.runtime.typeOf(result);
                if (type == JmesPathType.NULL) continue;
                results.add(result);
            }
            return (T)this.runtime.createArray(results);
        }
        return this.runtime.createNull();
    }

    @Override
    protected String internalToString() {
        return this.projection.toString();
    }

    @Override
    protected boolean internalEquals(Object o) {
        ProjectionNode other = (ProjectionNode)o;
        return this.projection.equals(other.projection);
    }

    @Override
    protected int internalHashCode() {
        return this.projection.hashCode();
    }
}

