/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.java.sampler;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaSamplerContext {
    private static final Logger log = LoggerFactory.getLogger(JavaSamplerContext.class);
    private final Map<String, String> params;

    public JavaSamplerContext(Arguments args) {
        this.params = args.getArgumentsAsMap();
    }

    public boolean containsParameter(String name) {
        return this.params.containsKey(name);
    }

    public Iterator<String> getParameterNamesIterator() {
        return this.params.keySet().iterator();
    }

    public String getParameter(String name) {
        return this.getParameter(name, null);
    }

    public String getParameter(String name, String defaultValue) {
        if (this.params == null || !this.params.containsKey(name)) {
            return defaultValue;
        }
        return this.params.get(name);
    }

    public int getIntParameter(String name) throws NumberFormatException {
        if (this.params == null || !this.params.containsKey(name)) {
            throw new NumberFormatException("No value for parameter named '" + name + "'.");
        }
        return Integer.decode(this.params.get(name));
    }

    public int getIntParameter(String name, int defaultValue) {
        if (this.params == null || !this.params.containsKey(name)) {
            return defaultValue;
        }
        try {
            return Integer.decode(this.params.get(name));
        }
        catch (NumberFormatException e) {
            log.warn("Value for parameter '" + name + "' not an integer: '" + this.params.get(name) + "'.  Using default: '" + defaultValue + "'.", (Throwable)e);
            return defaultValue;
        }
    }

    public long getLongParameter(String name) throws NumberFormatException {
        if (this.params == null || !this.params.containsKey(name)) {
            throw new NumberFormatException("No value for parameter named '" + name + "'.");
        }
        return Long.decode(this.params.get(name));
    }

    public long getLongParameter(String name, long defaultValue) {
        if (this.params == null || !this.params.containsKey(name)) {
            return defaultValue;
        }
        try {
            return Long.decode(this.params.get(name));
        }
        catch (NumberFormatException e) {
            log.warn("Value for parameter '" + name + "' not a long: '" + this.params.get(name) + "'.  Using default: '" + defaultValue + "'.", (Throwable)e);
            return defaultValue;
        }
    }

    public JMeterContext getJMeterContext() {
        return JMeterContextService.getContext();
    }

    public final JMeterVariables getJMeterVariables() {
        return JMeterContextService.getContext().getVariables();
    }

    public final Properties getJMeterProperties() {
        return JMeterUtils.getJMeterProperties();
    }
}

