/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Base64;
import org.apache.jmeter.config.ConfigElement;
import org.apache.jmeter.protocol.http.control.AuthManager;
import org.apache.jmeter.testelement.AbstractTestElement;

public class Authorization
extends AbstractTestElement
implements Serializable {
    private static final long serialVersionUID = 241L;
    private static final String URL = "Authorization.url";
    private static final String USERNAME = "Authorization.username";
    private static final String PASSWORD = "Authorization.password";
    private static final String DOMAIN = "Authorization.domain";
    private static final String REALM = "Authorization.realm";
    private static final String MECHANISM = "Authorization.mechanism";
    private static final String TAB = "\t";

    Authorization(String url, String user, String pass, String domain, String realm, AuthManager.Mechanism mechanism) {
        this.setURL(url);
        this.setUser(user);
        this.setPass(pass);
        this.setDomain(domain);
        this.setRealm(realm);
        this.setMechanism(mechanism);
    }

    public boolean expectsModification() {
        return false;
    }

    public Authorization() {
        this("", "", "", "", "", AuthManager.Mechanism.BASIC);
    }

    public void addConfigElement(ConfigElement config) {
    }

    public String getURL() {
        return this.getPropertyAsString(URL);
    }

    public void setURL(String url) {
        this.setProperty(URL, url);
    }

    public String getUser() {
        return this.getPropertyAsString(USERNAME);
    }

    public void setUser(String user) {
        this.setProperty(USERNAME, user);
    }

    public String getPass() {
        return this.getPropertyAsString(PASSWORD);
    }

    public void setPass(String pass) {
        this.setProperty(PASSWORD, pass);
    }

    public String getDomain() {
        return this.getPropertyAsString(DOMAIN);
    }

    public void setDomain(String domain) {
        this.setProperty(DOMAIN, domain);
    }

    public String getRealm() {
        return this.getPropertyAsString(REALM);
    }

    public void setRealm(String realm) {
        this.setProperty(REALM, realm);
    }

    public AuthManager.Mechanism getMechanism() {
        return AuthManager.Mechanism.valueOf(this.getPropertyAsString(MECHANISM, AuthManager.Mechanism.BASIC.name()));
    }

    public void setMechanism(AuthManager.Mechanism mechanism) {
        this.setProperty(MECHANISM, mechanism.name(), AuthManager.Mechanism.BASIC.name());
    }

    public String toString() {
        return this.getURL() + TAB + this.getUser() + TAB + this.getPass() + TAB + this.getDomain() + TAB + this.getRealm() + TAB + (Object)((Object)this.getMechanism());
    }

    public String toBasicHeader() {
        return "Basic " + new String(Base64.getEncoder().encode((this.getUser() + ":" + this.getPass()).getBytes(Charset.defaultCharset())), Charset.defaultCharset());
    }
}

