/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.reactor.core.publisher;

import java.util.Objects;
import java.util.function.Function;
import org.neo4j.driver.internal.shaded.reactor.core.CoreSubscriber;
import org.neo4j.driver.internal.shaded.reactor.core.Fuseable;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.FluxMapFuseable;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.InternalMonoOperator;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Mono;

final class MonoMapFuseable<T, R>
extends InternalMonoOperator<T, R>
implements Fuseable {
    final Function<? super T, ? extends R> mapper;

    MonoMapFuseable(Mono<? extends T> source, Function<? super T, ? extends R> mapper) {
        super(source);
        this.mapper = Objects.requireNonNull(mapper, "mapper");
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super R> actual) {
        if (actual instanceof Fuseable.ConditionalSubscriber) {
            Fuseable.ConditionalSubscriber cs = (Fuseable.ConditionalSubscriber)actual;
            return new FluxMapFuseable.MapFuseableConditionalSubscriber<T, R>(cs, this.mapper);
        }
        return new FluxMapFuseable.MapFuseableSubscriber<T, R>(actual, this.mapper);
    }
}

