/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.net.URI;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.ConnectionSettings;
import org.neo4j.driver.internal.DirectConnectionProvider;
import org.neo4j.driver.internal.InternalDriver;
import org.neo4j.driver.internal.Scheme;
import org.neo4j.driver.internal.SessionFactory;
import org.neo4j.driver.internal.SessionFactoryImpl;
import org.neo4j.driver.internal.async.connection.BootstrapFactory;
import org.neo4j.driver.internal.async.connection.ChannelConnector;
import org.neo4j.driver.internal.async.connection.ChannelConnectorImpl;
import org.neo4j.driver.internal.async.pool.ConnectionPoolImpl;
import org.neo4j.driver.internal.async.pool.PoolSettings;
import org.neo4j.driver.internal.cluster.IdentityResolver;
import org.neo4j.driver.internal.cluster.RoutingContext;
import org.neo4j.driver.internal.cluster.RoutingSettings;
import org.neo4j.driver.internal.cluster.loadbalancing.LeastConnectedLoadBalancingStrategy;
import org.neo4j.driver.internal.cluster.loadbalancing.LoadBalancer;
import org.neo4j.driver.internal.logging.NettyLogging;
import org.neo4j.driver.internal.metrics.InternalMetricsProvider;
import org.neo4j.driver.internal.metrics.MetricsProvider;
import org.neo4j.driver.internal.retry.ExponentialBackoffRetryLogic;
import org.neo4j.driver.internal.retry.RetryLogic;
import org.neo4j.driver.internal.retry.RetrySettings;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.Bootstrap;
import org.neo4j.driver.internal.shaded.io.netty.channel.EventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.EventExecutorGroup;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.spi.ConnectionProvider;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.ErrorUtil;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.net.ServerAddressResolver;

public class DriverFactory {
    public final Driver newInstance(URI uri, AuthToken authToken, RoutingSettings routingSettings, RetrySettings retrySettings, Config config, SecurityPlan securityPlan) {
        return this.newInstance(uri, authToken, routingSettings, retrySettings, config, null, securityPlan);
    }

    public final Driver newInstance(URI uri, AuthToken authToken, RoutingSettings routingSettings, RetrySettings retrySettings, Config config, EventLoopGroup eventLoopGroup, SecurityPlan securityPlan) {
        boolean ownsEventLoopGroup;
        Bootstrap bootstrap;
        if (eventLoopGroup == null) {
            bootstrap = this.createBootstrap(config.eventLoopThreads());
            ownsEventLoopGroup = true;
        } else {
            bootstrap = this.createBootstrap(eventLoopGroup);
            ownsEventLoopGroup = false;
        }
        authToken = authToken == null ? AuthTokens.none() : authToken;
        BoltServerAddress address = new BoltServerAddress(uri);
        RoutingSettings newRoutingSettings = routingSettings.withRoutingContext(new RoutingContext(uri));
        InternalLoggerFactory.setDefaultFactory(new NettyLogging(config.logging()));
        EventLoopGroup eventExecutorGroup = bootstrap.config().group();
        RetryLogic retryLogic = this.createRetryLogic(retrySettings, eventExecutorGroup, config.logging());
        MetricsProvider metricsProvider = DriverFactory.createDriverMetrics(config, this.createClock());
        ConnectionPool connectionPool = this.createConnectionPool(authToken, securityPlan, bootstrap, metricsProvider, config, ownsEventLoopGroup, newRoutingSettings.routingContext());
        return this.createDriver(uri, securityPlan, address, connectionPool, eventExecutorGroup, newRoutingSettings, retryLogic, metricsProvider, config);
    }

    protected ConnectionPool createConnectionPool(AuthToken authToken, SecurityPlan securityPlan, Bootstrap bootstrap, MetricsProvider metricsProvider, Config config, boolean ownsEventLoopGroup, RoutingContext routingContext) {
        Clock clock = this.createClock();
        ConnectionSettings settings = new ConnectionSettings(authToken, config.userAgent(), config.connectionTimeoutMillis());
        ChannelConnector connector = this.createConnector(settings, securityPlan, config, clock, routingContext);
        PoolSettings poolSettings = new PoolSettings(config.maxConnectionPoolSize(), config.connectionAcquisitionTimeoutMillis(), config.maxConnectionLifetimeMillis(), config.idleTimeBeforeConnectionTest());
        return new ConnectionPoolImpl(connector, bootstrap, poolSettings, metricsProvider.metricsListener(), config.logging(), clock, ownsEventLoopGroup);
    }

    protected static MetricsProvider createDriverMetrics(Config config, Clock clock) {
        if (config.isMetricsEnabled()) {
            return new InternalMetricsProvider(clock, config.logging());
        }
        return MetricsProvider.METRICS_DISABLED_PROVIDER;
    }

    protected ChannelConnector createConnector(ConnectionSettings settings, SecurityPlan securityPlan, Config config, Clock clock, RoutingContext routingContext) {
        return new ChannelConnectorImpl(settings, securityPlan, config.logging(), clock, routingContext);
    }

    private InternalDriver createDriver(URI uri, SecurityPlan securityPlan, BoltServerAddress address, ConnectionPool connectionPool, EventExecutorGroup eventExecutorGroup, RoutingSettings routingSettings, RetryLogic retryLogic, MetricsProvider metricsProvider, Config config) {
        try {
            String scheme = uri.getScheme().toLowerCase();
            if (Scheme.isRoutingScheme(scheme)) {
                return this.createRoutingDriver(securityPlan, address, connectionPool, eventExecutorGroup, routingSettings, retryLogic, metricsProvider, config);
            }
            DriverFactory.assertNoRoutingContext(uri, routingSettings);
            return this.createDirectDriver(securityPlan, address, connectionPool, retryLogic, metricsProvider, config);
        }
        catch (Throwable driverError) {
            DriverFactory.closeConnectionPoolAndSuppressError(connectionPool, driverError);
            throw driverError;
        }
    }

    protected InternalDriver createDirectDriver(SecurityPlan securityPlan, BoltServerAddress address, ConnectionPool connectionPool, RetryLogic retryLogic, MetricsProvider metricsProvider, Config config) {
        DirectConnectionProvider connectionProvider = new DirectConnectionProvider(address, connectionPool);
        SessionFactory sessionFactory = this.createSessionFactory(connectionProvider, retryLogic, config);
        InternalDriver driver = this.createDriver(securityPlan, sessionFactory, metricsProvider, config);
        Logger log = config.logging().getLog(Driver.class.getSimpleName());
        log.info("Direct driver instance %s created for server address %s", driver.hashCode(), address);
        return driver;
    }

    protected InternalDriver createRoutingDriver(SecurityPlan securityPlan, BoltServerAddress address, ConnectionPool connectionPool, EventExecutorGroup eventExecutorGroup, RoutingSettings routingSettings, RetryLogic retryLogic, MetricsProvider metricsProvider, Config config) {
        LoadBalancer connectionProvider = this.createLoadBalancer(address, connectionPool, eventExecutorGroup, config, routingSettings);
        SessionFactory sessionFactory = this.createSessionFactory(connectionProvider, retryLogic, config);
        InternalDriver driver = this.createDriver(securityPlan, sessionFactory, metricsProvider, config);
        Logger log = config.logging().getLog(Driver.class.getSimpleName());
        log.info("Routing driver instance %s created for server address %s", driver.hashCode(), address);
        return driver;
    }

    protected InternalDriver createDriver(SecurityPlan securityPlan, SessionFactory sessionFactory, MetricsProvider metricsProvider, Config config) {
        return new InternalDriver(securityPlan, sessionFactory, metricsProvider, config.logging());
    }

    protected LoadBalancer createLoadBalancer(BoltServerAddress address, ConnectionPool connectionPool, EventExecutorGroup eventExecutorGroup, Config config, RoutingSettings routingSettings) {
        LeastConnectedLoadBalancingStrategy loadBalancingStrategy = new LeastConnectedLoadBalancingStrategy(connectionPool, config.logging());
        ServerAddressResolver resolver = DriverFactory.createResolver(config);
        return new LoadBalancer(address, routingSettings, connectionPool, eventExecutorGroup, this.createClock(), config.logging(), loadBalancingStrategy, resolver);
    }

    private static ServerAddressResolver createResolver(Config config) {
        ServerAddressResolver configuredResolver = config.resolver();
        return configuredResolver != null ? configuredResolver : IdentityResolver.IDENTITY_RESOLVER;
    }

    protected Clock createClock() {
        return Clock.SYSTEM;
    }

    protected SessionFactory createSessionFactory(ConnectionProvider connectionProvider, RetryLogic retryLogic, Config config) {
        return new SessionFactoryImpl(connectionProvider, retryLogic, config);
    }

    protected RetryLogic createRetryLogic(RetrySettings settings, EventExecutorGroup eventExecutorGroup, Logging logging) {
        return new ExponentialBackoffRetryLogic(settings, eventExecutorGroup, this.createClock(), logging);
    }

    protected Bootstrap createBootstrap(int size) {
        return BootstrapFactory.newBootstrap(size);
    }

    protected Bootstrap createBootstrap(EventLoopGroup eventLoopGroup) {
        return BootstrapFactory.newBootstrap(eventLoopGroup);
    }

    private static void assertNoRoutingContext(URI uri, RoutingSettings routingSettings) {
        RoutingContext routingContext = routingSettings.routingContext();
        if (routingContext.isDefined()) {
            throw new IllegalArgumentException("Routing parameters are not supported with scheme 'bolt'. Given URI: '" + uri + "'");
        }
    }

    private static void closeConnectionPoolAndSuppressError(ConnectionPool connectionPool, Throwable mainError) {
        try {
            Futures.blockingGet(connectionPool.close());
        }
        catch (Throwable closeError) {
            ErrorUtil.addSuppressed(mainError, closeError);
        }
    }
}

