/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.cmdtools;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import kg.apc.cmdtools.AbstractCMDTool;

public class PluginsCMD
extends AbstractCMDTool {
    public int processParams(String[] args) {
        if (args == null) {
            args = new String[]{"--help"};
        }
        return this.processParams(PluginsCMD.argsArrayToListIterator(args));
    }

    public static ListIterator argsArrayToListIterator(String[] args) {
        List<String> arrayArgs = Arrays.asList(args);
        return new LinkedList<String>(arrayArgs).listIterator();
    }

    protected int processParams(ListIterator args) throws UnsupportedOperationException, IllegalArgumentException {
        AbstractCMDTool tool = null;
        while (args.hasNext()) {
            String arg = (String)args.next();
            if (arg.equals("-?") || arg.equals("--help")) {
                this.showHelp(System.out);
                return 0;
            }
            if (arg.equals("--version")) {
                this.showVersion(System.out);
                return 0;
            }
            if (arg.equals("")) {
                args.remove();
                continue;
            }
            if (!arg.equals("--tool")) continue;
            args.remove();
            if (!args.hasNext()) {
                throw new IllegalArgumentException("No tool name passed");
            }
            arg = (String)args.next();
            tool = this.getToolInstance(arg);
            args.remove();
        }
        if (tool == null) {
            throw new IllegalArgumentException("No suitable tool class provided in params");
        }
        while (args.hasPrevious()) {
            args.previous();
        }
        return tool.processParams(args);
    }

    private void showVersion(PrintStream os) {
        os.println("JP@GC Tools v2.0");
    }

    protected void showHelp(PrintStream os) {
        AbstractCMDTool tool;
        os.println("JMeter Plugins at jmeter-plugins.org Code Command-Line Tools");
        os.println("For help and support please visit http://jmeter-plugins.org/wiki/JMeterPluginsCMD");
        os.println("Usage:\n JMeterPluginsCMD --tool < Reporter | PerfMonAgent | TestPlanCheck | FilterResults > [--help]");
        try {
            tool = this.getToolInstance("Reporter");
            os.println();
            tool.showHelp(os);
        }
        catch (RuntimeException e) {
            os.println(e.getMessage());
        }
        try {
            tool = this.getToolInstance("PerfMonAgent");
            os.println();
            tool.showHelp(os);
        }
        catch (RuntimeException e) {
            os.println(e.getMessage());
        }
        try {
            tool = this.getToolInstance("TestPlanCheck");
            os.println();
            tool.showHelp(os);
        }
        catch (RuntimeException e) {
            os.println(e.getMessage());
        }
        try {
            tool = this.getToolInstance("FilterResults");
            os.println();
            tool.showHelp(os);
        }
        catch (RuntimeException e) {
            os.println(e.getMessage());
        }
    }

    private AbstractCMDTool getToolInstance(String arg) {
        Class<?> toolClass;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            toolClass = loader.loadClass("kg.apc.cmdtools." + arg + "Tool");
        }
        catch (ClassNotFoundException e) {
            try {
                toolClass = loader.loadClass(arg);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException("Tool class " + arg + " not found");
            }
        }
        if (!AbstractCMDTool.class.isAssignableFrom(toolClass)) {
            throw new IllegalArgumentException("Tool class " + arg + " not extends AbstractCMDTool");
        }
        try {
            return (AbstractCMDTool)toolClass.newInstance();
        }
        catch (InstantiationException ex) {
            throw new RuntimeException("Cannot instantiate tool class: " + arg, ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Cannot instantiate tool class: " + arg, ex);
        }
    }
}

