/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.charting.colors;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import kg.apc.charting.ColorsDispatcher;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class HueRotatePalette
implements ColorsDispatcher {
    List<Color> customPalette = new ArrayList<Color>(16);
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final int startingGradient = 0;
    private static final int maxGradient = 120;
    int i = 0;

    public HueRotatePalette(String options) {
        this.buildCustomPalette(options);
        this.reset();
    }

    private void buildCustomPalette(String options) {
        try {
            int i;
            String[] opts = options.split(",");
            Color baseColor = new Color(Integer.parseInt(opts[0].trim(), 16));
            int rotations = Integer.parseInt(opts[1]);
            int gradient_steps = Integer.parseInt(opts[2]);
            float[] hsbVals = new float[3];
            Color.RGBtoHSB(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), hsbVals);
            log.debug("Base color: " + baseColor + " rotations " + rotations + " hue: " + hsbVals[0]);
            for (i = 0; i <= rotations; ++i) {
                float hue = hsbVals[0] * (1.0f / (float)rotations) * (float)i;
                Color c = new Color(Color.HSBtoRGB(hue, hsbVals[1], hsbVals[2]));
                log.debug("Adding custom color (hue rotation): " + c);
                this.customPalette.add(c);
            }
            log.debug("Black->Gray gradient steps: " + gradient_steps);
            for (i = 0; i < 120; i += 120 / gradient_steps + 2) {
                Color c = new Color(i, i, i);
                log.debug("Adding gradient step: " + c);
                this.customPalette.add(c);
            }
        }
        catch (Exception e) {
            log.warn("Error building custom palette, using static palette: " + e.getClass().getName() + ": " + e.getMessage());
            this.useStaticPalette();
        }
    }

    private void useStaticPalette() {
        this.customPalette.add(new Color(11544359));
        this.customPalette.add(new Color(11558439));
        this.customPalette.add(new Color(11572775));
        this.customPalette.add(new Color(9678887));
        this.customPalette.add(new Color(6008871));
        this.customPalette.add(new Color(2601002));
        this.customPalette.add(new Color(2601058));
        this.customPalette.add(new Color(2601113));
        this.customPalette.add(new Color(2592944));
        this.customPalette.add(new Color(2578608));
        this.customPalette.add(new Color(2959280));
        this.customPalette.add(new Color(6629296));
        this.customPalette.add(new Color(10233776));
        this.customPalette.add(new Color(0));
        this.customPalette.add(new Color(0x333333));
        this.customPalette.add(new Color(0x666666));
    }

    @Override
    public void reset() {
        this.i = 0;
    }

    @Override
    public Color getNextColor() {
        if (this.i + 1 > this.customPalette.size()) {
            this.reset();
            return this.getNextColor();
        }
        Color c = this.customPalette.get(this.i);
        log.debug("Custom color c next: " + c);
        ++this.i;
        return c;
    }
}

