/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jms.sampler;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.jmeter.protocol.jms.sampler.JMSProperty;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.testelement.property.TestElementProperty;

public class JMSProperties
extends AbstractTestElement
implements Serializable {
    private static final long serialVersionUID = -2896138201054314563L;
    public static final String JMS_PROPERTIES = "JMSProperties.properties";

    public JMSProperties() {
        this.setProperty((JMeterProperty)new CollectionProperty(JMS_PROPERTIES, new ArrayList()));
    }

    public CollectionProperty getProperties() {
        return (CollectionProperty)this.getProperty(JMS_PROPERTIES);
    }

    public void clear() {
        super.clear();
        this.setProperty((JMeterProperty)new CollectionProperty(JMS_PROPERTIES, new ArrayList()));
    }

    public void setProperties(List<JMSProperty> jmsProperties) {
        this.setProperty((JMeterProperty)new CollectionProperty(JMS_PROPERTIES, jmsProperties));
    }

    public Map<String, Object> getJmsPropertysAsMap() {
        LinkedHashMap<String, Object> argMap = new LinkedHashMap<String, Object>();
        for (JMeterProperty jMeterProperty : this.getProperties()) {
            JMSProperty arg = (JMSProperty)jMeterProperty.getObjectValue();
            if (argMap.containsKey(arg.getName())) continue;
            argMap.put(arg.getName(), arg.getValueAsObject());
        }
        return argMap;
    }

    public void addJmsProperty(String name, String value) {
        this.addJmsProperty(new JMSProperty(name, value));
    }

    public void addJmsProperty(JMSProperty arg) {
        TestElementProperty newArg = new TestElementProperty(arg.getName(), (TestElement)arg);
        if (this.isRunningVersion()) {
            this.setTemporary((JMeterProperty)newArg);
        }
        this.getProperties().addItem((Object)newArg);
    }

    public void addJmsProperty(String name, String value, String type) {
        this.addJmsProperty(new JMSProperty(name, value, type));
    }

    public PropertyIterator iterator() {
        return this.getProperties().iterator();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        PropertyIterator iter = this.getProperties().iterator();
        while (iter.hasNext()) {
            JMSProperty arg = (JMSProperty)iter.next().getObjectValue();
            str.append(arg.toString());
            if (!iter.hasNext()) continue;
            str.append(",");
        }
        return str.toString();
    }

    public void removeJmsProperty(int row) {
        if (row < this.getProperties().size()) {
            this.getProperties().remove(row);
        }
    }

    public void removeJmsProperty(JMSProperty arg) {
        PropertyIterator iter = this.getProperties().iterator();
        while (iter.hasNext()) {
            JMSProperty item = (JMSProperty)iter.next().getObjectValue();
            if (!arg.equals(item)) continue;
            iter.remove();
        }
    }

    public void removeJmsProperty(String argName) {
        PropertyIterator iter = this.getProperties().iterator();
        while (iter.hasNext()) {
            JMSProperty arg = (JMSProperty)iter.next().getObjectValue();
            if (!arg.getName().equals(argName)) continue;
            iter.remove();
        }
    }

    public void removeAllJmsPropertys() {
        this.getProperties().clear();
    }

    public int getJmsPropertyCount() {
        return this.getProperties().size();
    }

    public JMSProperty getJmsProperty(int row) {
        JMSProperty argument = null;
        if (row < this.getProperties().size()) {
            argument = (JMSProperty)this.getProperties().get(row).getObjectValue();
        }
        return argument;
    }
}

