/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.charting.rows;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import kg.apc.charting.AbstractGraphPanelChartElement;
import kg.apc.charting.elements.GraphPanelChartExactElement;
import kg.apc.charting.rows.GraphRowSumValues;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class GraphRowPercentiles
extends GraphRowSumValues {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private ConcurrentSkipListMap<Long, AbstractGraphPanelChartElement> percentiles = new ConcurrentSkipListMap();
    private long totalCount = 0L;
    private static final int FRACTION = 10;

    public GraphRowPercentiles() {
        for (long p = 1L; p <= 999L; ++p) {
            this.percentiles.put(p, new GraphPanelChartExactElement(p, 0.0));
        }
    }

    @Override
    public void add(long xVal, double yVal) {
        super.add(xVal, yVal);
        ++this.totalCount;
    }

    @Override
    public long getMinX() {
        return 0L;
    }

    @Override
    public long getMaxX() {
        return 1000L;
    }

    private void calculatePercentiles() {
        double calculatedPerc = 0.0;
        Iterator<Map.Entry<Long, AbstractGraphPanelChartElement>> valIT = super.iterator();
        Map.Entry<Long, AbstractGraphPanelChartElement> el = null;
        Iterator<Map.Entry<Long, AbstractGraphPanelChartElement>> percIT = this.percentiles.entrySet().iterator();
        Long timeLevel = 0L;
        while (percIT.hasNext()) {
            Map.Entry<Long, AbstractGraphPanelChartElement> percEl = percIT.next();
            double percLevel = (double)percEl.getKey().longValue() / 10.0;
            while (calculatedPerc < percLevel && valIT.hasNext()) {
                el = valIT.next();
                calculatedPerc = 100.0 * el.getValue().getValue() / (double)this.totalCount;
            }
            if (el != null) {
                timeLevel = (Long)el.getKey();
            }
            percEl.getValue().add(timeLevel.longValue());
        }
    }

    @Override
    public Iterator<Map.Entry<Long, AbstractGraphPanelChartElement>> iterator() {
        this.calculatePercentiles();
        return this.percentiles.entrySet().iterator();
    }

    @Override
    public int size() {
        if (super.size() == 0) {
            return 0;
        }
        return this.percentiles.size();
    }

    @Override
    public AbstractGraphPanelChartElement getElement(long value) {
        return this.percentiles.get(value);
    }
}

