/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.url;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.url.IURLParameterList;
import com.helger.commons.url.URLParameter;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class URLParameterList
extends CommonsArrayList<URLParameter>
implements IURLParameterList<URLParameterList> {
    public URLParameterList() {
    }

    public URLParameterList(@Nullable List<? extends URLParameter> list) {
        super(list);
    }

    @Nonnull
    public URLParameterList remove(@Nullable String string) {
        this.removeIf(uRLParameter -> uRLParameter.hasName(string));
        return this;
    }

    @Nonnull
    public URLParameterList remove(@Nullable String string, @Nullable String string2) {
        this.removeIf(uRLParameter -> uRLParameter.hasName(string) && uRLParameter.hasValue(string2));
        return this;
    }

    public boolean contains(@Nullable String string) {
        return string != null && this.containsAny(uRLParameter -> uRLParameter.hasName(string));
    }

    public boolean contains(@Nullable String string, @Nullable String string2) {
        return string != null && string2 != null && this.containsAny(uRLParameter -> uRLParameter.hasName(string) && uRLParameter.hasValue(string2));
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<String> getAllParamNames() {
        CommonsLinkedHashSet<String> commonsLinkedHashSet = new CommonsLinkedHashSet<String>();
        this.forEach((? super E uRLParameter) -> commonsLinkedHashSet.add(uRLParameter.getName()));
        return commonsLinkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllParamValues(@Nullable String string) {
        CommonsArrayList<String> commonsArrayList = new CommonsArrayList<String>();
        if (string != null) {
            this.findAll(uRLParameter -> uRLParameter.hasName(string), uRLParameter -> commonsArrayList.add(uRLParameter.getValue()));
        }
        return commonsArrayList;
    }

    @Nullable
    public String getFirstParamValue(@Nullable String string) {
        return string == null ? null : this.findFirstMapped(uRLParameter -> uRLParameter.hasName(string), URLParameter::getValue);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, ICommonsList<String>> getAsMultiMap() {
        CommonsLinkedHashMap<String, ICommonsList<String>> commonsLinkedHashMap = new CommonsLinkedHashMap<String, ICommonsList<String>>();
        this.forEach((? super E uRLParameter) -> commonsLinkedHashMap.computeIfAbsent(uRLParameter.getName(), string -> new CommonsArrayList()).add(uRLParameter.getValue()));
        return commonsLinkedHashMap;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public URLParameterList getClone() {
        return new URLParameterList(this);
    }
}

