/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.string;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.StringHelper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class StringParser {
    public static final int DEFAULT_RADIX = 10;
    private static final StringParser s_aInstance = new StringParser();

    private StringParser() {
    }

    @Nonnull
    @Nonempty
    private static String _getUnifiedDecimal(@Nonnull @Nonempty String string) {
        return StringHelper.replaceAll(string, ',', '.');
    }

    public static boolean parseBool(@Nullable Object object) {
        return StringParser.parseBool(object, false);
    }

    public static boolean parseBool(@Nullable Object object, boolean bl) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return StringParser.parseBool((String)object);
        }
        return bl;
    }

    public static boolean parseBool(@Nullable String string) {
        return Boolean.parseBoolean(string);
    }

    public static boolean parseBool(@Nullable String string, boolean bl) {
        if (string != null && string.length() > 0) {
            if (string.equalsIgnoreCase("true")) {
                return true;
            }
            if (string.equalsIgnoreCase("false")) {
                return false;
            }
        }
        return bl;
    }

    @Nullable
    public static Boolean parseBoolObj(@Nullable Object object) {
        return StringParser.parseBoolObj(object, null);
    }

    @Nullable
    public static Boolean parseBoolObj(@Nullable Object object, @Nullable Boolean bl) {
        return object == null ? bl : StringParser.parseBoolObj(object.toString());
    }

    @Nonnull
    public static Boolean parseBoolObj(@Nullable String string) {
        return Boolean.valueOf(string);
    }

    @Nullable
    public static Boolean parseBoolObjExact(@Nullable String string) {
        return StringParser.parseBoolObjExact(string, null);
    }

    @Nullable
    public static Boolean parseBoolObjExact(@Nullable String string, @Nullable Boolean bl) {
        if (Boolean.TRUE.toString().equalsIgnoreCase(string)) {
            return Boolean.TRUE;
        }
        if (Boolean.FALSE.toString().equalsIgnoreCase(string)) {
            return Boolean.FALSE;
        }
        return bl;
    }

    public static byte parseByte(@Nullable Object object, byte by) {
        return StringParser.parseByte(object, 10, by);
    }

    public static byte parseByte(@Nullable Object object, @Nonnegative int n, byte by) {
        if (object == null) {
            return by;
        }
        if (object instanceof Number) {
            return ((Number)object).byteValue();
        }
        return StringParser.parseByte(object.toString(), n, by);
    }

    public static byte parseByte(@Nullable String string, byte by) {
        return StringParser.parseByte(string, 10, by);
    }

    public static byte parseByte(@Nullable String string, @Nonnegative int n, byte by) {
        if (string != null && string.length() > 0) {
            try {
                return Byte.parseByte(string, n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return by;
    }

    @Nullable
    public static Byte parseByteObj(@Nullable Object object) {
        return StringParser.parseByteObj(object, 10, null);
    }

    @Nullable
    public static Byte parseByteObj(@Nullable Object object, @Nullable Byte by) {
        return StringParser.parseByteObj(object, 10, by);
    }

    @Nullable
    public static Byte parseByteObj(@Nullable Object object, @Nonnegative int n, @Nullable Byte by) {
        if (object == null) {
            return by;
        }
        if (object instanceof Number) {
            return ((Number)object).byteValue();
        }
        return StringParser.parseByteObj(object.toString(), n, by);
    }

    @Nullable
    public static Byte parseByteObj(@Nullable String string) {
        return StringParser.parseByteObj(string, 10, null);
    }

    @Nullable
    public static Byte parseByteObj(@Nullable String string, @Nullable Byte by) {
        return StringParser.parseByteObj(string, 10, by);
    }

    @Nullable
    public static Byte parseByteObj(@Nullable String string, @Nonnegative int n, @Nullable Byte by) {
        if (string != null && string.length() > 0) {
            try {
                return Byte.valueOf(string, n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return by;
    }

    public static double parseDouble(@Nullable Object object, double d) {
        if (object == null) {
            return d;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        return StringParser.parseDouble(object.toString(), d);
    }

    public static double parseDouble(@Nullable String string, double d) {
        if (string != null && string.length() > 0) {
            try {
                return Double.parseDouble(StringParser._getUnifiedDecimal(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return d;
    }

    @Nullable
    public static Double parseDoubleObj(@Nullable Object object) {
        return StringParser.parseDoubleObj(object, null);
    }

    @Nullable
    public static Double parseDoubleObj(@Nullable Object object, @Nullable Double d) {
        double d2 = StringParser.parseDouble(object, Double.NaN);
        return Double.isNaN(d2) ? d : Double.valueOf(d2);
    }

    @Nullable
    public static Double parseDoubleObj(@Nullable String string) {
        return StringParser.parseDoubleObj(string, null);
    }

    @Nullable
    public static Double parseDoubleObj(@Nullable String string, @Nullable Double d) {
        double d2 = StringParser.parseDouble(string, Double.NaN);
        return Double.isNaN(d2) ? d : Double.valueOf(d2);
    }

    public static float parseFloat(@Nullable Object object, float f) {
        if (object == null) {
            return f;
        }
        if (object instanceof Number) {
            return ((Number)object).floatValue();
        }
        return StringParser.parseFloat(object.toString(), f);
    }

    public static float parseFloat(@Nullable String string, float f) {
        if (string != null && string.length() > 0) {
            try {
                return Float.parseFloat(StringParser._getUnifiedDecimal(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return f;
    }

    @Nullable
    public static Float parseFloatObj(@Nullable Object object) {
        return StringParser.parseFloatObj(object, null);
    }

    @Nullable
    public static Float parseFloatObj(@Nullable Object object, @Nullable Float f) {
        float f2 = StringParser.parseFloat(object, Float.NaN);
        return Float.isNaN(f2) ? f : Float.valueOf(f2);
    }

    @Nullable
    public static Float parseFloatObj(@Nullable String string) {
        return StringParser.parseFloatObj(string, null);
    }

    @Nullable
    public static Float parseFloatObj(@Nullable String string, @Nullable Float f) {
        float f2 = StringParser.parseFloat(string, Float.NaN);
        return Float.isNaN(f2) ? f : Float.valueOf(f2);
    }

    public static int parseInt(@Nullable Object object, int n) {
        return StringParser.parseInt(object, 10, n);
    }

    public static int parseInt(@Nullable Object object, @Nonnegative int n, int n2) {
        if (object == null) {
            return n2;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        return StringParser.parseInt(object.toString(), n, n2);
    }

    public static int parseInt(@Nullable String string, int n) {
        return StringParser.parseInt(string, 10, n);
    }

    public static int parseInt(@Nullable String string, @Nonnegative int n, int n2) {
        if (string != null && string.length() > 0) {
            try {
                return Integer.parseInt(string, n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }

    @Nullable
    public static Integer parseIntObj(@Nullable Object object) {
        return StringParser.parseIntObj(object, 10, null);
    }

    @Nullable
    public static Integer parseIntObj(@Nullable Object object, @Nullable Integer n) {
        return StringParser.parseIntObj(object, 10, n);
    }

    @Nullable
    public static Integer parseIntObj(@Nullable Object object, @Nonnegative int n, @Nullable Integer n2) {
        if (object == null) {
            return n2;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        return StringParser.parseIntObj(object.toString(), n, n2);
    }

    @Nullable
    public static Integer parseIntObj(@Nullable String string) {
        return StringParser.parseIntObj(string, 10, null);
    }

    @Nullable
    public static Integer parseIntObj(@Nullable String string, @Nullable Integer n) {
        return StringParser.parseIntObj(string, 10, n);
    }

    @Nullable
    public static Integer parseIntObj(@Nullable String string, @Nonnegative int n, @Nullable Integer n2) {
        if (string != null && string.length() > 0) {
            try {
                return Integer.valueOf(string, n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }

    @Nullable
    public static Long parseUnsignedIntObj(@Nullable String string) {
        return StringParser.parseUnsignedIntObj(string, 10, null);
    }

    @Nullable
    public static Long parseUnsignedIntObj(@Nullable String string, @Nullable Long l) {
        return StringParser.parseUnsignedIntObj(string, 10, l);
    }

    @Nullable
    public static Long parseUnsignedIntObj(@Nullable String string, @Nonnegative int n, @Nullable Long l) {
        if (string != null && string.length() > 0) {
            try {
                return (long)Integer.parseUnsignedInt(string, n) & 0xFFFFFFFFL;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return l;
    }

    public static long parseLong(@Nullable Object object, long l) {
        return StringParser.parseLong(object, 10, l);
    }

    public static long parseLong(@Nullable Object object, @Nonnegative int n, long l) {
        if (object == null) {
            return l;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        return StringParser.parseLong(object.toString(), n, l);
    }

    public static long parseLong(@Nullable String string, long l) {
        return StringParser.parseLong(string, 10, l);
    }

    public static long parseLong(@Nullable String string, @Nonnegative int n, long l) {
        if (string != null && string.length() > 0) {
            try {
                return Long.parseLong(string, n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return l;
    }

    @Nullable
    public static Long parseLongObj(@Nullable Object object) {
        return StringParser.parseLongObj(object, 10, null);
    }

    @Nullable
    public static Long parseLongObj(@Nullable Object object, @Nullable Long l) {
        return StringParser.parseLongObj(object, 10, l);
    }

    @Nullable
    public static Long parseLongObj(@Nullable Object object, @Nonnegative int n, @Nullable Long l) {
        if (object == null) {
            return l;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        return StringParser.parseLongObj(object.toString(), n, l);
    }

    @Nullable
    public static Long parseLongObj(@Nullable String string) {
        return StringParser.parseLongObj(string, 10, null);
    }

    @Nullable
    public static Long parseLongObj(@Nullable String string, @Nullable Long l) {
        return StringParser.parseLongObj(string, 10, l);
    }

    @Nullable
    public static Long parseLongObj(@Nullable String string, @Nonnegative int n, @Nullable Long l) {
        if (string != null && string.length() > 0) {
            try {
                return Long.valueOf(string, n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return l;
    }

    public static short parseShort(@Nullable Object object, short s) {
        return StringParser.parseShort(object, 10, s);
    }

    public static short parseShort(@Nullable Object object, @Nonnegative int n, short s) {
        if (object == null) {
            return s;
        }
        if (object instanceof Number) {
            return ((Number)object).shortValue();
        }
        return StringParser.parseShort(object.toString(), n, s);
    }

    public static short parseShort(@Nullable String string, short s) {
        return StringParser.parseShort(string, 10, s);
    }

    public static short parseShort(@Nullable String string, @Nonnegative int n, short s) {
        if (string != null && string.length() > 0) {
            try {
                return Short.parseShort(string, n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return s;
    }

    @Nullable
    public static Short parseShortObj(@Nullable Object object) {
        return StringParser.parseShortObj(object, 10, null);
    }

    @Nullable
    public static Short parseShortObj(@Nullable Object object, @Nullable Short s) {
        return StringParser.parseShortObj(object, 10, s);
    }

    @Nullable
    public static Short parseShortObj(@Nullable Object object, @Nonnegative int n, @Nullable Short s) {
        if (object == null) {
            return s;
        }
        if (object instanceof Number) {
            return ((Number)object).shortValue();
        }
        return StringParser.parseShortObj(object.toString(), n, s);
    }

    @Nullable
    public static Short parseShortObj(@Nullable String string) {
        return StringParser.parseShortObj(string, 10, null);
    }

    @Nullable
    public static Short parseShortObj(@Nullable String string, @Nullable Short s) {
        return StringParser.parseShortObj(string, 10, s);
    }

    @Nullable
    public static Short parseShortObj(@Nullable String string, @Nonnegative int n, @Nullable Short s) {
        if (string != null && string.length() > 0) {
            try {
                return Short.valueOf(string, n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return s;
    }

    @Nullable
    public static BigInteger parseBigInteger(@Nullable String string) {
        return StringParser.parseBigInteger(string, 10, null);
    }

    @Nullable
    public static BigInteger parseBigInteger(@Nullable String string, @Nonnegative int n) {
        return StringParser.parseBigInteger(string, n, null);
    }

    @Nullable
    public static BigInteger parseBigInteger(@Nullable String string, @Nullable BigInteger bigInteger) {
        return StringParser.parseBigInteger(string, 10, bigInteger);
    }

    @Nullable
    public static BigInteger parseBigInteger(@Nullable String string, @Nonnegative int n, @Nullable BigInteger bigInteger) {
        if (string != null && string.length() > 0) {
            try {
                return new BigInteger(string, n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return bigInteger;
    }

    @Nullable
    public static BigDecimal parseBigDecimal(@Nullable String string) {
        return StringParser.parseBigDecimal(string, null);
    }

    @Nullable
    public static BigDecimal parseBigDecimal(@Nullable String string, @Nullable BigDecimal bigDecimal) {
        if (string != null && string.length() > 0) {
            try {
                return new BigDecimal(StringParser._getUnifiedDecimal(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return bigDecimal;
    }

    @Nullable
    public static BigDecimal parseBigDecimal(@Nullable String string, @Nonnegative int n, @Nonnull RoundingMode roundingMode) {
        return StringParser.parseBigDecimal(string, n, roundingMode, null);
    }

    @Nullable
    public static BigDecimal parseBigDecimal(@Nullable String string, @Nonnegative int n, @Nonnull RoundingMode roundingMode, @Nullable BigDecimal bigDecimal) {
        ValueEnforcer.isGE0(n, "Scale");
        ValueEnforcer.notNull(roundingMode, "RoundingMode");
        if (string != null && string.length() > 0) {
            try {
                return new BigDecimal(StringParser._getUnifiedDecimal(string)).setScale(n, roundingMode);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return bigDecimal;
    }

    public static boolean isInt(@Nullable String string) {
        if (string != null) {
            try {
                Integer.parseInt(string, 10);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isLong(@Nullable String string) {
        if (string != null) {
            try {
                Long.parseLong(string, 10);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isUnsignedInt(@Nullable String string) {
        if (string != null) {
            try {
                Integer.parseUnsignedInt(string, 10);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isUnsignedLong(@Nullable String string) {
        if (string != null) {
            try {
                long l = Long.parseLong(string, 10);
                return l >= 0L;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isDouble(@Nullable String string) {
        return !Double.isNaN(StringParser.parseDouble(string, Double.NaN));
    }

    public static boolean isFloat(@Nullable String string) {
        return !Float.isNaN(StringParser.parseFloat(string, Float.NaN));
    }
}

