/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.attr;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.callback.ICallback;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.state.EChange;
import com.helger.commons.state.EContinue;
import com.helger.commons.traits.IGetterByKeyTrait;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IAttributeContainer<KEYTYPE, VALUETYPE>
extends ICommonsMap<KEYTYPE, VALUETYPE>,
IGetterByKeyTrait<KEYTYPE> {
    @Override
    @Nullable
    default public VALUETYPE getValue(@Nullable KEYTYPE KEYTYPE) {
        return (VALUETYPE)this.get(KEYTYPE);
    }

    @Override
    default public int getAsInt(@Nullable KEYTYPE KEYTYPE) {
        return this.getAsInt(KEYTYPE, -1);
    }

    @Override
    default public long getAsLong(@Nullable KEYTYPE KEYTYPE) {
        return this.getAsLong(KEYTYPE, -1L);
    }

    @Override
    default public float getAsFloat(@Nullable KEYTYPE KEYTYPE) {
        return this.getAsFloat(KEYTYPE, -1.0f);
    }

    @Override
    default public double getAsDouble(@Nullable KEYTYPE KEYTYPE) {
        return this.getAsDouble(KEYTYPE, -1.0);
    }

    @Override
    default public boolean getAsBoolean(@Nullable KEYTYPE KEYTYPE) {
        return this.getAsBoolean(KEYTYPE, false);
    }

    @Nonnull
    @ReturnsMutableObject
    public CallbackList<IBeforeSetValueCallback<KEYTYPE, VALUETYPE>> beforeSetValueCallbacks();

    @Nonnull
    @ReturnsMutableObject
    public CallbackList<IAfterSetValueCallback<KEYTYPE, VALUETYPE>> afterSetValueCallbacks();

    @Nonnull
    default public EChange putIn(@Nonnull KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        ValueEnforcer.notNull(KEYTYPE, "Name");
        if (this.beforeSetValueCallbacks().forEachBreakable((Function<IBeforeSetValueCallback<KEYTYPE, VALUETYPE>, EContinue>)((Function<IBeforeSetValueCallback, EContinue>)iBeforeSetValueCallback -> iBeforeSetValueCallback.beforeSetValue(KEYTYPE, VALUETYPE))).isBreak()) {
            return EChange.UNCHANGED;
        }
        Object VALUETYPE2 = this.put(KEYTYPE, VALUETYPE);
        if (EqualsHelper.equals(VALUETYPE, VALUETYPE2)) {
            return EChange.UNCHANGED;
        }
        this.afterSetValueCallbacks().forEach((Consumer<IAfterSetValueCallback<KEYTYPE, VALUETYPE>>)((Consumer<IAfterSetValueCallback>)iAfterSetValueCallback -> iAfterSetValueCallback.afterSetValue(KEYTYPE, VALUETYPE2, VALUETYPE)));
        return EChange.CHANGED;
    }

    @Nonnull
    default public EChange putAllIn(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        EChange eChange = EChange.UNCHANGED;
        if (map != null) {
            for (Map.Entry<KEYTYPE, VALUETYPE> entry : map.entrySet()) {
                eChange = eChange.or(this.putIn(entry.getKey(), entry.getValue()));
            }
        }
        return eChange;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public IAttributeContainer<KEYTYPE, VALUETYPE> getClone();

    @FunctionalInterface
    public static interface IAfterSetValueCallback<KEYTYPE, VALUETYPE>
    extends ICallback {
        public void afterSetValue(@Nonnull KEYTYPE var1, @Nullable VALUETYPE var2, @Nullable VALUETYPE var3);
    }

    @FunctionalInterface
    public static interface IBeforeSetValueCallback<KEYTYPE, VALUETYPE>
    extends ICallback {
        @Nonnull
        public EContinue beforeSetValue(@Nonnull KEYTYPE var1, @Nullable VALUETYPE var2);
    }
}

