/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.perfmon.metrics.jmx;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import kg.apc.perfmon.metrics.jmx.ClassesDataProvider;
import kg.apc.perfmon.metrics.jmx.CompilerDataProvider;
import kg.apc.perfmon.metrics.jmx.GCDataProvider;
import kg.apc.perfmon.metrics.jmx.MemoryDataProvider;
import kg.apc.perfmon.metrics.jmx.MemoryPoolDataProvider;

public abstract class AbstractJMXDataProvider {
    protected final Set beans;
    private final boolean isDiff;
    private long prevValue = 0L;
    protected boolean bytesValue = false;

    public AbstractJMXDataProvider(MBeanServerConnection mBeanServerConn, boolean diff) throws Exception {
        this.isDiff = diff;
        this.beans = this.getMXBeans(mBeanServerConn);
    }

    public static AbstractJMXDataProvider getProvider(MBeanServerConnection mBeanServerConn, String type) throws Exception {
        if (type.startsWith("gc-")) {
            return new GCDataProvider(mBeanServerConn, true);
        }
        if (type.startsWith("class-")) {
            return new ClassesDataProvider(mBeanServerConn, false);
        }
        if (type.startsWith("compile-")) {
            return new CompilerDataProvider(mBeanServerConn, true);
        }
        if (type.startsWith("memorypool-")) {
            if (type.endsWith("-committed")) {
                return new MemoryPoolDataProvider(mBeanServerConn, false, 1);
            }
            return new MemoryPoolDataProvider(mBeanServerConn, false, 0);
        }
        if (type.startsWith("memory-")) {
            if (type.endsWith("-committed")) {
                return new MemoryDataProvider(mBeanServerConn, false, 1);
            }
            return new MemoryDataProvider(mBeanServerConn, false, 0);
        }
        throw new IllegalArgumentException("Can't define JMX type");
    }

    private Set getMXBeans(MBeanServerConnection mBeanServerConn) throws MalformedObjectNameException, NullPointerException, IOException {
        ObjectName gcAllObjectName = new ObjectName(this.getMXBeanType() + ",*");
        Set<ObjectName> gcMXBeanObjectNames = mBeanServerConn.queryNames(gcAllObjectName, null);
        Iterator<ObjectName> it = gcMXBeanObjectNames.iterator();
        HashSet res = new HashSet();
        while (it.hasNext()) {
            ObjectName on = it.next();
            Object mxBean = ManagementFactory.newPlatformMXBeanProxy(mBeanServerConn, on.getCanonicalName(), this.getMXBeanClass());
            res.add(mxBean);
        }
        return res;
    }

    protected abstract String getMXBeanType();

    protected abstract Class getMXBeanClass();

    protected abstract long getValueFromBean(Object var1);

    public boolean isBytesValue() {
        return this.bytesValue;
    }

    public void getValue(StringBuffer res) {
        this.getValue(res, 1);
    }

    public void getValue(StringBuffer res, int divider) {
        Iterator it = this.beans.iterator();
        long value = 0L;
        while (it.hasNext()) {
            value += this.getValueFromBean(it.next());
        }
        if (this.isDiff) {
            if (this.prevValue == 0L) {
                this.prevValue = value;
                value = 0L;
            } else {
                long oldVal = value;
                value -= this.prevValue;
                this.prevValue = oldVal;
            }
        }
        res.append(Long.toString(value /= (long)divider));
    }
}

