/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.perfmon;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import kg.apc.perfmon.PerfMonMetricGetter;
import kg.apc.perfmon.metrics.SysInfoLogger;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.SigarProxyCache;

public class PerfMonWorker
implements Runnable {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private int tcpPort = 4444;
    private int udpPort = 4444;
    private boolean isFinished = true;
    private final Selector acceptSelector;
    private ServerSocketChannel tcpServer;
    private final Thread writerThread;
    private final Selector sendSelector;
    private DatagramChannel udpServer;
    private final LinkedList<SelectableChannel> tcpConnections = new LinkedList();
    private final Hashtable udpConnections = new Hashtable();
    private long interval = 1000L;
    private final SigarProxy sigar;
    private long numConnections = 0L;
    private boolean autoShutdown = false;
    private boolean isNoExec = false;

    public PerfMonWorker() throws IOException {
        this.acceptSelector = Selector.open();
        this.sendSelector = Selector.open();
        this.writerThread = new Thread(this);
        this.sigar = SigarProxyCache.newInstance((Sigar)new Sigar(), (int)500);
    }

    public void setTCPPort(int parseInt) {
        this.tcpPort = parseInt;
    }

    public void setUDPPort(int parseInt) {
        this.udpPort = parseInt;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public void processCommands() throws IOException {
        if (this.isFinished) {
            throw new IOException("Worker finished");
        }
        if (!this.acceptSelector.isOpen() || this.tcpServer == null && this.udpServer == null) {
            throw new IOException("Nothing to do with this settings");
        }
        this.acceptSelector.select();
        Iterator<SelectionKey> keys = this.acceptSelector.selectedKeys().iterator();
        while (keys.hasNext()) {
            SelectionKey key = keys.next();
            keys.remove();
            if (!key.isValid()) continue;
            if (key.isAcceptable()) {
                this.accept(key);
                continue;
            }
            if (!key.isReadable()) continue;
            try {
                this.read(key);
            }
            catch (IOException e) {
                log.error("Error reading from the network layer", (Throwable)e);
                this.notifyDisonnected();
                key.cancel();
            }
        }
    }

    public int getExitCode() {
        return -1;
    }

    public void startAcceptingCommands() {
        log.debug("Start accepting connections");
        this.isFinished = false;
        this.writerThread.start();
        boolean started = false;
        try {
            this.listenUDP();
            started = true;
        }
        catch (IOException ex) {
            log.error("Can't accept UDP connections", (Throwable)ex);
        }
        try {
            this.listenTCP();
            started = true;
        }
        catch (IOException ex) {
            log.error("Can't accept TCP connections", (Throwable)ex);
        }
        if (started) {
            log.info("JP@GC Agent v" + this.getVersion() + " started");
        }
    }

    private long getInterval() {
        return this.interval;
    }

    private void listenTCP() throws IOException {
        if (this.tcpPort > 0) {
            log.info("Binding TCP to " + this.tcpPort);
            this.tcpServer = ServerSocketChannel.open();
            this.tcpServer.configureBlocking(false);
            this.tcpServer.socket().bind(new InetSocketAddress(this.tcpPort));
            this.tcpServer.register(this.acceptSelector, 16);
        }
    }

    private void listenUDP() throws IOException {
        if (this.udpPort > 0) {
            log.info("Binding UDP to " + this.udpPort);
            DatagramChannel udp = DatagramChannel.open();
            udp.socket().bind(new InetSocketAddress(this.udpPort));
            udp.configureBlocking(false);
            udp.register(this.acceptSelector, 1);
            udp.register(this.sendSelector, 4);
        }
    }

    private void accept(SelectionKey key) throws IOException {
        log.info("Accepting new TCP connection");
        ++this.numConnections;
        SelectableChannel channel = key.channel();
        SocketChannel tcpConn = ((ServerSocketChannel)channel).accept();
        ((SelectableChannel)tcpConn).configureBlocking(false);
        SelectionKey k = tcpConn.register(this.acceptSelector, 1);
        log.debug("Creating new metric getter");
        PerfMonMetricGetter getter = new PerfMonMetricGetter(this.sigar, this, tcpConn);
        k.attach(getter);
        this.tcpConnections.add(tcpConn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(SelectionKey key) throws IOException {
        AbstractSelectableChannel channel;
        PerfMonMetricGetter getter = null;
        ByteBuffer buf = ByteBuffer.allocateDirect(1024);
        if (key.channel() instanceof SocketChannel) {
            channel = (SocketChannel)key.channel();
            if (((SocketChannel)channel).read(buf) < 0) {
                log.info("Closing TCP connection");
                channel.close();
                this.notifyDisonnected();
                return;
            }
            getter = (PerfMonMetricGetter)key.attachment();
        } else if (key.channel() instanceof DatagramChannel) {
            channel = (DatagramChannel)key.channel();
            SocketAddress remoteAddr = ((DatagramChannel)channel).receive(buf);
            if (remoteAddr == null) {
                throw new IOException("Received null datagram");
            }
            Hashtable hashtable = this.udpConnections;
            synchronized (hashtable) {
                if (!this.udpConnections.containsKey(remoteAddr)) {
                    this.connectUDPClient(remoteAddr, (DatagramChannel)channel, new PerfMonMetricGetter(this.sigar, this, (DatagramChannel)channel, remoteAddr));
                }
                getter = (PerfMonMetricGetter)this.udpConnections.get(remoteAddr);
            }
        }
        buf.flip();
        log.debug("Read: " + buf.toString());
        getter.addCommandString(PerfMonWorker.byteBufferToString(buf));
        try {
            while (getter.processNextCommand()) {
                log.debug("Done executing command");
            }
        }
        catch (Exception e) {
            log.error("Error executing command", (Throwable)e);
        }
    }

    public void shutdownConnections() throws IOException {
        log.info("Shutdown connections");
        this.isFinished = true;
        Iterator it = this.tcpConnections.iterator();
        while (it.hasNext()) {
            SelectableChannel entry = (SelectableChannel)it.next();
            log.debug("Closing " + entry);
            entry.close();
            it.remove();
        }
        if (this.udpServer != null) {
            this.udpServer.close();
        }
        if (this.tcpServer != null) {
            this.tcpServer.close();
        }
        this.acceptSelector.close();
        this.sendSelector.close();
    }

    public void run() {
        while (!this.isFinished) {
            try {
                this.processSenders();
            }
            catch (IOException ex) {
                log.error("Error processing senders", (Throwable)ex);
                break;
            }
        }
    }

    public void registerWritingChannel(SelectableChannel channel, PerfMonMetricGetter worker) throws ClosedChannelException {
        this.sendSelector.wakeup();
        channel.register(this.sendSelector, 4, worker);
    }

    private void processSenders() throws IOException {
        this.sendSelector.select(this.getInterval());
        long begin = System.currentTimeMillis();
        Iterator<SelectionKey> keys = this.sendSelector.selectedKeys().iterator();
        while (keys.hasNext()) {
            SelectionKey key = keys.next();
            keys.remove();
            if (!key.isValid() || !key.isWritable()) continue;
            try {
                if (key.channel() instanceof DatagramChannel) {
                    this.sendToUDP(key);
                    continue;
                }
                PerfMonMetricGetter getter = (PerfMonMetricGetter)key.attachment();
                ByteBuffer metrics = getter.getMetricsLine();
                ((WritableByteChannel)((Object)key.channel())).write(metrics);
            }
            catch (IOException e) {
                log.error("Cannot send data to network connection", (Throwable)e);
                this.notifyDisonnected();
                key.cancel();
            }
        }
        long spent = System.currentTimeMillis() - begin;
        if (spent < this.getInterval()) {
            try {
                Thread.sleep(this.getInterval() - spent);
            }
            catch (InterruptedException ex) {
                log.debug("Thread interrupted", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToUDP(SelectionKey key) throws IOException {
        Hashtable hashtable = this.udpConnections;
        synchronized (hashtable) {
            for (Object o : this.udpConnections.keySet()) {
                SocketAddress addr = (SocketAddress)o;
                PerfMonMetricGetter getter = (PerfMonMetricGetter)this.udpConnections.get(addr);
                if (!getter.isStarted()) continue;
                ByteBuffer metrics = getter.getMetricsLine();
                ((DatagramChannel)key.channel()).send(metrics, addr);
            }
        }
    }

    private static String byteBufferToString(ByteBuffer bytebuff) {
        byte[] bytearr = new byte[bytebuff.remaining()];
        bytebuff.get(bytearr);
        return new String(bytearr);
    }

    public void setInterval(long parseInt) {
        log.debug("Setting interval to: " + parseInt + " seconds");
        this.interval = parseInt * 1000L;
    }

    public void logVersion() {
        log.info("JMeter Plugins Agent v" + this.getVersion());
    }

    public void logSysInfo() {
        SysInfoLogger.doIt(this.sigar);
    }

    public void setAutoShutdown() {
        log.info("Agent will shutdown when all clients disconnected");
        this.autoShutdown = true;
    }

    public void notifyDisonnected() throws IOException {
        --this.numConnections;
        if (this.autoShutdown) {
            log.debug("Num connections: " + this.numConnections);
        }
        if (this.numConnections == 0L && this.autoShutdown) {
            log.info("Auto-shutdown triggered");
            this.shutdownConnections();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendToClient(SelectableChannel channel, ByteBuffer buf) throws IOException {
        if (channel instanceof DatagramChannel) {
            Hashtable hashtable = this.udpConnections;
            synchronized (hashtable) {
                DatagramChannel udpChannel = (DatagramChannel)channel;
                for (Object o : this.udpConnections.keySet()) {
                    SocketAddress addr = (SocketAddress)o;
                    if (this.udpConnections.get(addr) != udpChannel) continue;
                    udpChannel.send(buf, addr);
                }
            }
        } else {
            ((SocketChannel)channel).write(buf);
        }
    }

    private String getVersion() {
        Properties props = new Properties();
        try {
            props.load(this.getClass().getResourceAsStream("version.properties"));
        }
        catch (IOException ex) {
            log.warn("Can't get version info", (Throwable)ex);
            props.setProperty("version", "N/A");
        }
        return props.getProperty("version");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectUDPClient(SocketAddress remoteAddr, DatagramChannel channel, PerfMonMetricGetter getter) throws IOException {
        log.info("Connecting new UDP client");
        Hashtable hashtable = this.udpConnections;
        synchronized (hashtable) {
            ++this.numConnections;
            this.udpConnections.put(remoteAddr, getter);
        }
    }

    public boolean isNoExec() {
        return this.isNoExec;
    }

    public void setNoExec(boolean noExec) {
        this.isNoExec = noExec;
    }
}

