/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.perfmon.metrics;

import java.util.Arrays;
import kg.apc.perfmon.metrics.AbstractMemMetric;
import kg.apc.perfmon.metrics.MetricParamsSigar;
import org.hyperic.sigar.ProcMem;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;

class MemProcMetric
extends AbstractMemMetric {
    public static final byte VIRTUAL = 0;
    public static final byte SHARED = 1;
    public static final byte PAGE_FAULTS = 2;
    public static final byte MAJOR_FAULTS = 3;
    public static final byte MINOR_FAULTS = 4;
    public static final byte RESIDENT = 5;
    public static final String[] types = new String[]{"virtual", "shared", "pagefaults", "majorfaults", "minorfaults", "resident"};
    private int type = -1;
    private double prev = -1.0;
    private int dividingFactor = 1;

    public MemProcMetric(SigarProxy aSigar, MetricParamsSigar params) {
        super(aSigar, params);
        if (params.type.length() == 0) {
            this.type = 5;
        } else {
            this.type = Arrays.asList(types).indexOf(params.type);
            if (this.type < 0) {
                throw new IllegalArgumentException("Invalid proc mem type: " + params.type);
            }
        }
        this.dividingFactor = this.getUnitDividingFactor(params.getUnit());
    }

    public void getValue(StringBuffer res) throws SigarException {
        ProcMem mem = this.sigarProxy.getProcMem(this.params.PID);
        int factor = 1;
        switch (this.type) {
            case 0: {
                double val = mem.getSize();
                factor = this.dividingFactor;
                break;
            }
            case 1: {
                long cur = mem.getShare();
                this.prev = cur;
                double val = cur;
                factor = this.dividingFactor;
                break;
            }
            case 2: {
                long cur = mem.getPageFaults();
                double val = this.prev > 0.0 ? (double)cur - this.prev : 0.0;
                this.prev = cur;
                break;
            }
            case 3: {
                long cur = mem.getMajorFaults();
                double val = this.prev > 0.0 ? (double)cur - this.prev : 0.0;
                this.prev = cur;
                break;
            }
            case 4: {
                long cur = mem.getMinorFaults();
                double val = this.prev > 0.0 ? (double)cur - this.prev : 0.0;
                this.prev = cur;
                break;
            }
            case 5: {
                long cur = mem.getResident();
                this.prev = cur;
                double val = cur;
                factor = this.dividingFactor;
                break;
            }
            default: {
                throw new SigarException("Unknown proc mem type " + this.type);
            }
        }
        res.append(Double.toString(val /= (double)factor));
    }
}

