/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.extractor.json.jmespath;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import io.burt.jmespath.Expression;
import io.burt.jmespath.JmesPath;
import io.burt.jmespath.RuntimeConfiguration;
import io.burt.jmespath.function.FunctionRegistry;
import io.burt.jmespath.jackson.JacksonRuntime;
import org.apache.jmeter.util.JMeterUtils;

public class JMESPathCache {
    private final LoadingCache<String, Expression<JsonNode>> JMES_PATH_CACHE = Caffeine.newBuilder().maximumSize((long)JMeterUtils.getPropDefault((String)"jmespath.parser.cache.size", (int)400)).build((CacheLoader)new JMESPathCacheLoader());

    private JMESPathCache() {
    }

    public static JMESPathCache getInstance() {
        return JMESPathCacheHolder.INSTANCE;
    }

    public Expression<JsonNode> get(String key) {
        return (Expression)this.JMES_PATH_CACHE.get((Object)key);
    }

    public void cleanUp() {
        this.JMES_PATH_CACHE.cleanUp();
    }

    private static class JMESPathCacheHolder {
        public static final JMESPathCache INSTANCE = new JMESPathCache();

        private JMESPathCacheHolder() {
        }
    }

    private static final class JMESPathCacheLoader
    implements CacheLoader<String, Expression<JsonNode>> {
        final JmesPath<JsonNode> runtime = new JacksonRuntime(new RuntimeConfiguration.Builder().withFunctionRegistry(FunctionRegistry.defaultRegistry()).build());

        public Expression<JsonNode> load(String jmesPathExpression) throws Exception {
            return this.runtime.compile(jmesPathExpression);
        }
    }
}

