/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions.jmespath.gui;

import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.jmeter.assertions.gui.JSONPathAssertionGui;
import org.apache.jmeter.assertions.jmespath.JMESPathAssertion;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.gui.util.JSyntaxTextArea;
import org.apache.jmeter.gui.util.JTextScrollPane;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

@TestElementMetadata(labelResource="jmespath_assertion_title")
public class JMESPathAssertionGui
extends JSONPathAssertionGui {
    private static final long serialVersionUID = 3719848809836264945L;
    private static final String JMES_ASSERTION_PATH = "jmespath_assertion_path";
    private static final String JMES_ASSERTION_VALIDATION = "jmespath_assertion_validation";
    private static final String JMES_ASSERTION_REGEX = "jmespath_assertion_regex";
    private static final String JMES_ASSERTION_EXPECTED_VALUE = "jmespath_assertion_expected_value";
    private static final String JMES_ASSERTION_NULL = "jmespath_assertion_null";
    private static final String JMES_ASSERTION_INVERT = "jmespath_assertion_invert";
    private static final String JMES_ASSERTION_TITLE = "jmespath_assertion_title";

    @Override
    protected JPanel buildPanel() {
        JPanel panel = new JPanel((LayoutManager)new MigLayout("fillx, wrap 2, insets 0", "[][fill,grow]"));
        this.jsonPath = new JTextField();
        panel.add(JMeterUtils.labelFor((Component)this.jsonPath, (String)JMES_ASSERTION_PATH));
        panel.add((Component)this.jsonPath, "span, growx");
        this.jsonValidation = new JCheckBox();
        panel.add(JMeterUtils.labelFor((Component)this.jsonValidation, (String)JMES_ASSERTION_VALIDATION));
        panel.add((Component)this.jsonValidation, "span");
        this.isRegex = new JCheckBox();
        panel.add(JMeterUtils.labelFor((Component)this.isRegex, (String)JMES_ASSERTION_REGEX));
        panel.add((Component)this.isRegex, "span");
        this.jsonValue = JSyntaxTextArea.getInstance((int)5, (int)60);
        panel.add(JMeterUtils.labelFor((Component)this.jsonValue, (String)JMES_ASSERTION_EXPECTED_VALUE));
        panel.add((Component)JTextScrollPane.getInstance((JSyntaxTextArea)this.jsonValue));
        this.expectNull = new JCheckBox();
        panel.add(JMeterUtils.labelFor((Component)this.expectNull, (String)JMES_ASSERTION_NULL));
        panel.add((Component)this.expectNull, "span");
        this.invert = new JCheckBox();
        panel.add(JMeterUtils.labelFor((Component)this.invert, (String)JMES_ASSERTION_INVERT));
        panel.add((Component)this.invert, "span");
        return panel;
    }

    @Override
    public TestElement createTestElement() {
        JMESPathAssertion jmesAssertion = new JMESPathAssertion();
        this.modifyTestElement((TestElement)jmesAssertion);
        return jmesAssertion;
    }

    @Override
    public String getLabelResource() {
        return JMES_ASSERTION_TITLE;
    }

    @Override
    public void modifyTestElement(TestElement element) {
        super.configureTestElement(element);
        if (element instanceof JMESPathAssertion) {
            JMESPathAssertion jmesAssertion = (JMESPathAssertion)element;
            jmesAssertion.setJmesPath(this.jsonPath.getText());
            jmesAssertion.setExpectedValue(this.jsonValue.getText());
            jmesAssertion.setJsonValidationBool(this.jsonValidation.isSelected());
            jmesAssertion.setExpectNull(this.expectNull.isSelected());
            jmesAssertion.setInvert(this.invert.isSelected());
            jmesAssertion.setIsRegex(this.isRegex.isSelected());
        }
    }

    @Override
    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof JMESPathAssertion) {
            JMESPathAssertion jmesAssertion = (JMESPathAssertion)element;
            this.jsonPath.setText(jmesAssertion.getJmesPath());
            this.jsonValue.setText(jmesAssertion.getExpectedValue());
            this.jsonValidation.setSelected(jmesAssertion.isJsonValidationBool());
            this.expectNull.setSelected(jmesAssertion.isExpectNull());
            this.invert.setSelected(jmesAssertion.isInvert());
            this.isRegex.setSelected(jmesAssertion.isUseRegex());
        }
    }
}

