/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tabframe;

import com.github.weisj.darklaf.components.tabframe.JTabFrame;
import com.github.weisj.darklaf.components.tabframe.TabFrameTabLabel;
import com.github.weisj.darklaf.icons.RotatableIcon;
import com.github.weisj.darklaf.listener.HoverListener;
import com.github.weisj.darklaf.ui.label.DarkLabelUI;
import com.github.weisj.darklaf.ui.tabframe.DarkTabFrameComponentPopupMenu;
import com.github.weisj.darklaf.ui.tabframe.TabDragListener;
import com.github.weisj.darklaf.ui.tabframe.TabFrameUtil;
import com.github.weisj.darklaf.util.Alignment;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class DarkTabFrameTabLabelUI
extends DarkLabelUI
implements PropertyChangeListener {
    private TabFrameTabLabel tabComponent;
    private final MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!DarkTabFrameTabLabelUI.this.tabComponent.isEnabled()) {
                return;
            }
            if (SwingUtilities.isLeftMouseButton(e)) {
                DarkTabFrameTabLabelUI.this.tabComponent.getTabFrame().toggleTab(DarkTabFrameTabLabelUI.this.tabComponent.getOrientation(), DarkTabFrameTabLabelUI.this.tabComponent.getIndex(), !DarkTabFrameTabLabelUI.this.tabComponent.isSelected());
            }
        }
    };
    private TabDragListener dragListener;
    private HoverListener hoverListener;
    private Color defaultFontColor;
    private Color selectedFontColor;
    private Color fontHoverColor;
    private Color selectedColor;
    private Color hoverColor;
    private final RotatableIcon rotatableIcon = new RotatableIcon();
    private boolean printing;

    public static ComponentUI createUI(JComponent c) {
        return new DarkTabFrameTabLabelUI();
    }

    @Override
    protected void paintBackground(Graphics g, JComponent c) {
        g.setColor(this.getBackground(this.tabComponent));
        g.fillRect(0, 0, this.tabComponent.getWidth(), this.tabComponent.getHeight());
    }

    @Override
    public void installUI(JComponent c) {
        this.tabComponent = (TabFrameTabLabel)c;
        super.installUI(c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallListeners(this.tabComponent);
        if (this.tabComponent.getComponentPopupMenu() instanceof UIResource) {
            this.tabComponent.setComponentPopupMenu(null);
        }
        this.hoverListener = null;
        this.tabComponent = null;
    }

    @Override
    protected void installDefaults(JLabel c) {
        super.installDefaults(c);
        this.tabComponent.setFont(UIManager.getFont("TabFrameTab.font"));
        this.tabComponent.setOpaque(true);
        this.defaultFontColor = UIManager.getColor("TabFrameTab.foreground");
        this.selectedColor = UIManager.getColor("TabFrameTab.selectedBackground");
        this.hoverColor = UIManager.getColor("TabFrameTab.hoverBackground");
        this.selectedFontColor = UIManager.getColor("TabFrameTab.selectedForeground");
        this.fontHoverColor = UIManager.getColor("TabFrameTab.hoverForeground");
        LookAndFeel.installBorder(c, "TabFrameTab.border");
        this.tabComponent.setComponentPopupMenu(new DarkTabFrameComponentPopupMenu(this.tabComponent));
    }

    @Override
    protected void installListeners(JLabel c) {
        super.installListeners(c);
        this.dragListener = new TabDragListener(this.tabComponent);
        this.hoverListener = new HoverListener(this.tabComponent);
        this.tabComponent.addMouseListener(this.hoverListener);
        this.tabComponent.addMouseListener(this.mouseListener);
        this.installAccelerator(this.tabComponent.getTabFrame());
        this.tabComponent.addMouseMotionListener(this.dragListener);
        this.tabComponent.addMouseListener(this.dragListener);
    }

    @Override
    protected void uninstallListeners(JLabel c) {
        super.uninstallListeners(c);
        this.tabComponent.removeMouseListener(this.hoverListener);
        this.tabComponent.removeMouseListener(this.mouseListener);
        this.uninstallAccelerator(this.tabComponent.getTabFrame());
        this.tabComponent.removeMouseMotionListener(this.dragListener);
        this.tabComponent.removeMouseListener(this.dragListener);
        this.dragListener = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        String key = e.getPropertyName();
        if ("selected".equals(key)) {
            this.tabComponent.setForeground(Boolean.TRUE.equals(e.getNewValue()) ? this.selectedFontColor : this.defaultFontColor);
            this.tabComponent.repaint();
        } else if ("title".equals(key)) {
            this.updateText();
        } else if ("accelerator".equals(key)) {
            this.updateText();
            if (this.tabComponent == null) {
                return;
            }
            this.uninstallAccelerator(this.tabComponent.getTabFrame());
            this.installAccelerator(this.tabComponent.getTabFrame());
        } else if ("orientation".equals(key)) {
            this.rotatableIcon.setOrientation(this.mapOrientation(this.tabComponent.getOrientation()));
            this.hoverListener.refresh();
        } else if ("tabFrame".equals(key)) {
            if (e.getOldValue() instanceof JTabFrame) {
                this.uninstallAccelerator((JTabFrame)e.getOldValue());
            }
            if (e.getNewValue() instanceof JTabFrame) {
                this.installAccelerator((JTabFrame)e.getNewValue());
            }
        } else if ("paintingForPrint".equals(key)) {
            this.printing = Boolean.TRUE.equals(e.getNewValue());
        }
    }

    protected void updateText() {
        String title = this.tabComponent.getTitle();
        title = title == null ? "" : title;
        int accelerator = this.tabComponent.getAccelerator();
        if (accelerator >= 0 && accelerator <= 9) {
            this.tabComponent.setText(accelerator + ":" + title);
            this.tabComponent.setDisplayedMnemonicIndex(0);
        } else {
            this.tabComponent.setText(title);
            this.tabComponent.setDisplayedMnemonicIndex(1);
        }
    }

    protected void installAccelerator(JTabFrame tabFrame) {
        TabFrameUtil.installAccelerator(tabFrame, this.tabComponent);
    }

    protected void uninstallAccelerator(JTabFrame tabFrame) {
        TabFrameUtil.uninstallAccelerator(tabFrame, this.tabComponent);
    }

    public Color getBackground(TabFrameTabLabel tab) {
        if (this.printing || !tab.isEnabled()) {
            return tab.getBackground();
        }
        return tab.isSelected() ? this.selectedColor : (this.hoverListener.isHover() && !tab.getTabFrame().isInTransfer() ? this.hoverColor : tab.getBackground());
    }

    @Override
    protected Color getEnabledForeground(Component label) {
        return this.getTabForeground((TabFrameTabLabel)label);
    }

    public Color getTabForeground(TabFrameTabLabel tab) {
        if (this.printing) {
            return tab.getForeground();
        }
        return tab.isSelected() ? this.selectedFontColor : (this.hoverListener.isHover() && !tab.getTabFrame().isInTransfer() ? this.fontHoverColor : tab.getForeground());
    }

    @Override
    protected Icon getIcon(JLabel label) {
        Icon icon;
        Icon icon2 = icon = this.tabComponent.isEnabled() ? this.tabComponent.getIcon() : this.tabComponent.getDisabledIcon();
        if (icon == null) {
            return null;
        }
        this.rotatableIcon.setIcon(icon);
        if (this.rotatableIcon.getOrientation() == null) {
            this.rotatableIcon.setOrientation(this.mapOrientation(this.tabComponent.getOrientation()));
        }
        return this.rotatableIcon;
    }

    protected Alignment mapOrientation(Alignment newValue) {
        switch (newValue) {
            case CENTER: 
            case NORTH: 
            case NORTH_EAST: 
            case SOUTH: 
            case SOUTH_WEST: {
                return Alignment.NORTH;
            }
            case EAST: 
            case SOUTH_EAST: {
                return Alignment.WEST;
            }
            case WEST: 
            case NORTH_WEST: {
                return Alignment.EAST;
            }
        }
        return Alignment.NORTH;
    }
}

