/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.colorchooser;

import com.github.weisj.darklaf.color.DarkColorModel;
import com.github.weisj.darklaf.ui.colorchooser.ColorListener;
import com.github.weisj.darklaf.ui.colorchooser.ColorTriangle;
import com.github.weisj.darklaf.ui.colorchooser.SlideComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class ColorWheelPanel
extends JPanel {
    private final ColorTriangle colorWheel;
    private SlideComponent opacitySlider = null;
    private boolean enableOpacity;

    public ColorWheelPanel(boolean enableOpacity, boolean opacityInPercent) {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.enableOpacity = enableOpacity;
        this.colorWheel = new ColorTriangle();
        this.add((Component)this.colorWheel, "Center");
        if (enableOpacity) {
            this.opacitySlider = new SlideComponent("Opacity", false, true);
            this.opacitySlider.setToolTipText("Opacity");
            this.opacitySlider.setUnits(opacityInPercent ? SlideComponent.Unit.PERCENT : SlideComponent.Unit.LEVEL);
            this.opacitySlider.addListener((Integer integer) -> {
                this.colorWheel.setOpacity((double)integer.intValue() / 255.0);
                this.repaint();
            });
            this.add((Component)this.opacitySlider, "South");
            this.colorWheel.addListener(this.opacitySlider);
        }
    }

    public void addListener(ColorListener listener) {
        this.colorWheel.addListener(listener);
    }

    public void setColor(Color color, Object source) {
        if (this.opacitySlider != null) {
            this.opacitySlider.setValue(color.getAlpha());
            this.opacitySlider.repaint();
        }
        this.colorWheel.setColor(source, color);
    }

    public boolean isColorTransparencySelectionEnabled() {
        return this.enableOpacity;
    }

    public void setColorTransparencySelectionEnabled(boolean b) {
        if (b != this.enableOpacity) {
            this.enableOpacity = b;
            this.opacitySlider.setEnabled(b);
            this.opacitySlider.setVisible(b);
        }
    }

    public void setModel(DarkColorModel darkColorModel) {
        this.colorWheel.setColorModel(darkColorModel);
    }
}

