/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.treetable;

import com.github.weisj.darklaf.components.treetable.model.TreeTableModel;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeTableModelAdapter
extends AbstractTableModel {
    private final JTree tree;
    private final TreeTableModel treeTableModel;

    public TreeTableModelAdapter(TreeTableModel treeTableModel, final JTree tree) {
        this.tree = tree;
        this.treeTableModel = treeTableModel;
        tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                TreePath path = event.getPath();
                int start = tree.getRowForPath(path);
                int length = ((TreeNode)path.getLastPathComponent()).getChildCount();
                int selection = tree.getLeadSelectionRow();
                TreeTableModelAdapter.this.fireTableRowsInserted(start, start + length);
                tree.setSelectionRow(selection);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                TreePath path = event.getPath();
                int start = tree.getRowForPath(path);
                int length = ((TreeNode)path.getLastPathComponent()).getChildCount();
                int selection = tree.getLeadSelectionRow();
                TreeTableModelAdapter.this.fireTableRowsDeleted(start, start + length);
                tree.setSelectionRow(selection);
            }
        });
    }

    @Override
    public int getColumnCount() {
        return this.treeTableModel.getColumnCount();
    }

    @Override
    public String getColumnName(int column) {
        return this.treeTableModel.getColumnName(column);
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return this.treeTableModel.getColumnClass(column);
    }

    @Override
    public int getRowCount() {
        return this.tree.getRowCount();
    }

    protected Object nodeForRow(int row) {
        TreePath treePath = this.tree.getPathForRow(row);
        return treePath.getLastPathComponent();
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.treeTableModel.getValueAt(this.nodeForRow(row), column);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.treeTableModel.isCellEditable(this.nodeForRow(row), column);
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        this.treeTableModel.setValueAt(value, this.nodeForRow(row), column);
    }
}

