/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.togglebuttonlist;

import com.github.weisj.darklaf.components.togglebuttonlist.CheckBoxListItem;
import com.github.weisj.darklaf.components.togglebuttonlist.ToggleButtonListCellRenderer;
import com.github.weisj.darklaf.util.Actions;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JList;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;

public class JToggleButtonList
extends JList<JToggleButton> {
    public JToggleButtonList() {
        super.setModel(new DefaultListModel());
        super.setCellRenderer(new ToggleButtonListCellRenderer());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int index = JToggleButtonList.this.locationToIndex(e.getPoint());
                Rectangle bounds = JToggleButtonList.this.getCellBounds(index, index);
                if (index != -1) {
                    JToggleButton toggleButton = (JToggleButton)JToggleButtonList.this.getModel().getElementAt(index);
                    Point p = e.getPoint();
                    boolean inside = toggleButton.contains(p.x - bounds.x, p.y - bounds.y);
                    if (e.getClickCount() >= 2 || inside) {
                        toggleButton.setSelected(!toggleButton.isSelected());
                        JToggleButtonList.this.fireSelectionValueChanged(index, index, inside);
                    }
                    JToggleButtonList.this.repaint();
                }
            }
        });
        InputMap map = this.getInputMap(1);
        map.put(KeyStroke.getKeyStroke("released SPACE"), "toggle_togglebutton");
        this.getActionMap().put("toggle_togglebutton", Actions.create((String)"toggle_togglebutton", e -> {
            int leadIndex = this.getSelectionModel().getLeadSelectionIndex();
            if (leadIndex >= 0) {
                this.setSelected(leadIndex, !this.isSelected(leadIndex));
            }
        }));
        super.setSelectionMode(0);
    }

    public void addToggleButton(String text) {
        this.addToggleButton(text, false);
    }

    public void addToggleButton(String text, boolean selected) {
        this.addToggleButton(this.getModel().getSize(), text, selected);
    }

    public void addToggleButton(int index, String text) {
        this.addToggleButton(index, text, false);
    }

    public void addToggleButton(int index, String text, boolean selected) {
        this.addToggleButton(index, new CheckBoxListItem((Object)text, selected));
    }

    public void addToggleButton(JToggleButton item) {
        this.addToggleButton(this.getModel().getSize(), item);
    }

    public void addToggleButton(int index, JToggleButton item) {
        this.gettogglebuttonModel().add(index, item);
    }

    public boolean isSelected(int index) {
        return this.gettogglebuttonModel().get(index).isSelected();
    }

    public void setSelected(int index, boolean selected) {
        this.gettogglebuttonModel().get(index).setSelected(selected);
        this.repaint(this.getCellBounds(index, index));
    }

    private DefaultListModel<JToggleButton> gettogglebuttonModel() {
        return (DefaultListModel)this.getModel();
    }

    public int[] getCheckedIndices() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        ListModel dlm = this.getModel();
        for (int i = 0; i < dlm.getSize(); ++i) {
            JToggleButton togglebutton = (JToggleButton)this.getModel().getElementAt(i);
            if (!togglebutton.isSelected()) continue;
            list.add(i);
        }
        return list.stream().mapToInt(Integer::intValue).toArray();
    }

    public List<JToggleButton> getCheckedItems() {
        ArrayList<JToggleButton> list = new ArrayList<JToggleButton>();
        ListModel dlm = this.getModel();
        for (int i = 0; i < dlm.getSize(); ++i) {
            JToggleButton togglebutton = (JToggleButton)dlm.getElementAt(i);
            if (!togglebutton.isSelected()) continue;
            list.add(togglebutton);
        }
        return list;
    }

    @Override
    public void setModel(ListModel<JToggleButton> model) {
    }

    @Override
    public void setSelectionMode(int selectionMode) {
    }

    @Override
    public void setSelectionModel(ListSelectionModel selectionModel) {
    }

    @Override
    public void setCellRenderer(ListCellRenderer<? super JToggleButton> cellRenderer) {
    }
}

