/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.popup;

import com.github.weisj.darklaf.LafManager;
import com.github.weisj.darklaf.components.chooser.ChooserComponent;
import com.github.weisj.darklaf.components.tooltip.ToolTipContext;
import com.github.weisj.darklaf.util.Actions;
import com.github.weisj.darklaf.util.Alignment;
import com.github.weisj.darklaf.util.DarkUIUtil;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;

public class AttachedPopupComponent
extends JToolTip {
    private final JComponent content;
    private static ToolTipContext context;

    protected AttachedPopupComponent(JComponent parent, JComponent content) {
        this.setComponent(parent);
        this.setLayout(new BorderLayout());
        this.content = content;
        this.add(content);
        this.setBackground(content.getBackground());
    }

    public static <K, T extends JComponent> void attachChooser(JComponent component, Supplier<T> chooserSupplier, Consumer<K> callback, Supplier<K> initialValueSupplier) {
        AttachedPopupComponent.attachChooser(component, chooserSupplier, callback, initialValueSupplier, true);
    }

    public static <K, T extends JComponent> void attachChooser(JComponent component, Supplier<T> chooserSupplier, Consumer<K> callback, Supplier<K> initialValueSupplier, boolean revertOnAbort) {
        AttachedPopupComponent.attackToComponent(component, () -> {
            JComponent comp = (JComponent)chooserSupplier.get();
            ((ChooserComponent)((Object)comp)).reset(initialValueSupplier.get(), callback);
            return comp;
        }, p -> callback.accept(((ChooserComponent)((Object)p)).getSelected()), p -> {
            if (revertOnAbort) {
                callback.accept(((ChooserComponent)((Object)p)).getInitial());
            }
        });
    }

    public static <T extends JComponent> void attackToComponent(JComponent component, Supplier<T> componentSupplier, Consumer<T> onClose, Consumer<T> onAbort) {
        AtomicBoolean isShowing = new AtomicBoolean(false);
        Runnable listener = () -> {
            if (!component.isEnabled() || isShowing.get()) {
                return;
            }
            JComponent content = (JComponent)componentSupplier.get();
            if (content == null) {
                return;
            }
            isShowing.set(true);
            AttachedPopupComponent.showComponent(component, content, () -> onClose.accept(content), () -> onAbort.accept(content), () -> isShowing.set(false));
        };
        if (component instanceof AbstractButton) {
            ((AbstractButton)component).addActionListener(e -> listener.run());
        } else {
            component.addMouseListener(e -> {
                if (e.isConsumed()) {
                    return;
                }
                listener.run();
            });
        }
    }

    public static void showComponent(JComponent parent, JComponent content, Runnable onClose, Runnable onAbort, Runnable afterClose) {
        if (LafManager.isInstalled()) {
            AttachedPopupComponent.showComponentImpl(parent, content, onClose, onAbort, afterClose);
        } else {
            AttachedPopupComponent.showComponentFallbackImpl(parent, content, onClose, onAbort, afterClose);
        }
    }

    public static void showComponentImpl(JComponent parent, JComponent content, Runnable onClose, Runnable onAbort, Runnable afterClose) {
        AttachedPopupComponent attachedComp = new AttachedPopupComponent(parent, content);
        Popup popup = PopupFactory.getSharedInstance().getPopup(parent, attachedComp, 0, 0);
        popup.show();
        Window window = DarkUIUtil.getWindow(parent);
        final AtomicReference<BiConsumer<AWTEvent, Boolean>> close = new AtomicReference<BiConsumer<AWTEvent, Boolean>>();
        final AtomicReference<Runnable> listenerRemover = new AtomicReference<Runnable>();
        AtomicBoolean open = new AtomicBoolean(true);
        ComponentAdapter windowListener = new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                ((BiConsumer)close.get()).accept(e, true);
                ((Runnable)listenerRemover.get()).run();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                ((BiConsumer)close.get()).accept(e, true);
                ((Runnable)listenerRemover.get()).run();
            }
        };
        AWTEventListener listener = event -> {
            boolean doClose;
            if (event instanceof MouseEvent) {
                int id = event.getID();
                if (id != 500 && id != 501) {
                    return;
                }
                if (id == 500 && !open.get()) {
                    ((Runnable)listenerRemover.get()).run();
                    ((MouseEvent)event).consume();
                    return;
                }
            }
            boolean bl = doClose = event instanceof FocusEvent && !DarkUIUtil.hasFocus(attachedComp, (FocusEvent)event) && !DarkUIUtil.hasFocus(attachedComp) && !DarkUIUtil.hasFocus(parent, (FocusEvent)event);
            if (!doClose) {
                Point p = MouseInfo.getPointerInfo().getLocation();
                Point p2 = new Point(p);
                Point p3 = new Point(p);
                SwingUtilities.convertPointFromScreen(p2, parent);
                SwingUtilities.convertPointFromScreen(p3, attachedComp);
                boolean bl2 = doClose = !parent.contains(p2) && !attachedComp.contains(p3);
            }
            if (doClose) {
                ((BiConsumer)close.get()).accept(event, true);
                if (event instanceof InputEvent) {
                    ((InputEvent)event).consume();
                }
            }
        };
        close.set((e, runCloseAction) -> {
            if (!open.get()) {
                return;
            }
            popup.hide();
            open.set(false);
            if (onClose != null && runCloseAction.booleanValue()) {
                onClose.run();
            }
        });
        listenerRemover.set(() -> {
            Toolkit.getDefaultToolkit().removeAWTEventListener(listener);
            if (window != null) {
                window.removeComponentListener(windowListener);
            }
            afterClose.run();
        });
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0);
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        attachedComp.getInputMap(2).put(escape, "closeEscape");
        attachedComp.getInputMap(2).put(enter, "closeEnter");
        attachedComp.getActionMap().put("closeEscape", Actions.create(e -> {
            onAbort.run();
            ((BiConsumer)close.get()).accept(e, false);
            ((Runnable)listenerRemover.get()).run();
        }));
        attachedComp.getActionMap().put("closeEnter", Actions.create(e -> {
            ((BiConsumer)close.get()).accept(e, true);
            ((Runnable)listenerRemover.get()).run();
        }));
        SwingUtilities.invokeLater(() -> {
            window.addComponentListener(windowListener);
            Toolkit.getDefaultToolkit().addAWTEventListener(listener, 20L);
        });
    }

    public static void showComponentFallbackImpl(JComponent parent, JComponent content, Runnable onClose, Runnable onAbort, Runnable afterClose) {
        int returnCode = JOptionPane.showOptionDialog(parent, content, "Dialog", -1, -1, null, null, null);
        switch (returnCode) {
            case -1: 
            case 2: {
                onAbort.run();
                break;
            }
            default: {
                onClose.run();
            }
        }
        afterClose.run();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.putClientProperty("JPopupFactory.focusablePopup", true);
        this.putClientProperty("JToolTip.style", "balloon");
        this.putClientProperty("JToolTip.toolTipContext", this.getContext());
        super.updateUI();
        if (this.content != null) {
            this.setBackground(this.content.getBackground());
        }
    }

    protected ToolTipContext getContext() {
        if (context == null) {
            context = this.createToolTipContext();
        }
        return context;
    }

    protected ToolTipContext createToolTipContext() {
        return new ToolTipContext().setAlignment(Alignment.CENTER).setCenterAlignment(Alignment.SOUTH).setUseBestFit(true).setToolTipInsets(new Insets(2, 2, 2, 2)).setFallBackPositionProvider(c -> {
            Window window = DarkUIUtil.getWindow(c.getTarget());
            Dimension size = c.getToolTip().getPreferredSize();
            Rectangle bounds = window.getBounds();
            return new Point(bounds.x + (bounds.width - size.width) / 2, bounds.y + (bounds.height - size.height) / 2);
        });
    }

    @Override
    public String getTipText() {
        return "NO_TEXT";
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        if (this.getLayout() != null) {
            return this.getLayout().preferredLayoutSize(this);
        }
        return super.getPreferredSize();
    }
}

