/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.jcf;

import io.burt.jmespath.BaseRuntime;
import io.burt.jmespath.JmesPathType;
import io.burt.jmespath.RuntimeConfiguration;
import io.burt.jmespath.jcf.JsonParser;
import io.burt.jmespath.util.StringEscapeHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class JcfRuntime
extends BaseRuntime<Object> {
    private static final StringEscapeHelper jsonEscapeHelper = new StringEscapeHelper(true, 'b', '\b', 't', '\t', 'n', '\n', 'f', '\f', 'r', '\r', '\\', '\\', '\"', '\"');

    public JcfRuntime() {
    }

    public JcfRuntime(RuntimeConfiguration configuration) {
        super(configuration);
    }

    @Override
    public Object parseString(String string) {
        return JsonParser.fromString(string, this);
    }

    @Override
    public List<Object> toList(Object value) {
        switch (this.typeOf(value)) {
            case ARRAY: {
                if (value instanceof List) {
                    return (List)value;
                }
                return new ArrayList<Object>((Collection)value);
            }
            case OBJECT: {
                Map object = (Map)value;
                return new ArrayList<Object>(object.values());
            }
        }
        return Collections.emptyList();
    }

    @Override
    public String toString(Object str) {
        if (this.typeOf(str) == JmesPathType.STRING) {
            return (String)str;
        }
        return this.unparse(str);
    }

    @Override
    public Number toNumber(Object n) {
        if (this.typeOf(n) == JmesPathType.NUMBER) {
            return (Number)n;
        }
        return null;
    }

    @Override
    public JmesPathType typeOf(Object value) {
        if (value == null) {
            return JmesPathType.NULL;
        }
        if (value instanceof Boolean) {
            return JmesPathType.BOOLEAN;
        }
        if (value instanceof Number) {
            return JmesPathType.NUMBER;
        }
        if (value instanceof Map) {
            return JmesPathType.OBJECT;
        }
        if (value instanceof Collection) {
            return JmesPathType.ARRAY;
        }
        if (value instanceof String) {
            return JmesPathType.STRING;
        }
        throw new IllegalStateException(String.format("Unknown node type encountered: %s", value.getClass().getName()));
    }

    @Override
    public boolean isTruthy(Object value) {
        switch (this.typeOf(value)) {
            case NULL: {
                return false;
            }
            case NUMBER: {
                return true;
            }
            case BOOLEAN: {
                return (Boolean)value;
            }
            case ARRAY: {
                return !((Collection)value).isEmpty();
            }
            case OBJECT: {
                return !((Map)value).isEmpty();
            }
            case STRING: {
                return !((String)value).isEmpty();
            }
        }
        throw new IllegalStateException(String.format("Unknown node type encountered: %s", value.getClass().getName()));
    }

    @Override
    public Object getProperty(Object value, Object name) {
        if (this.typeOf(value) == JmesPathType.OBJECT) {
            return ((Map)value).get(name);
        }
        return null;
    }

    @Override
    public Collection<Object> getPropertyNames(Object value) {
        if (this.typeOf(value) == JmesPathType.OBJECT) {
            return ((Map)value).keySet();
        }
        return Collections.emptyList();
    }

    @Override
    public Object createNull() {
        return null;
    }

    @Override
    public Object createArray(Collection<Object> elements) {
        if (elements instanceof List) {
            return elements;
        }
        return new ArrayList<Object>(elements);
    }

    @Override
    public Object createString(String str) {
        return str;
    }

    @Override
    public Object createBoolean(boolean b) {
        return b;
    }

    @Override
    public Object createObject(Map<Object, Object> obj) {
        return obj;
    }

    @Override
    public Object createNumber(double n) {
        return n;
    }

    @Override
    public Object createNumber(long n) {
        return n;
    }

    private String unparse(Object object) {
        switch (this.typeOf(object)) {
            case NUMBER: 
            case BOOLEAN: {
                return object.toString();
            }
            case NULL: {
                return "null";
            }
            case STRING: {
                return '\"' + jsonEscapeHelper.escape(this.toString(object)) + '\"';
            }
            case OBJECT: {
                return this.unparseObject(object);
            }
            case ARRAY: {
                return this.unparseArray(object);
            }
        }
        throw new IllegalStateException();
    }

    private String unparseObject(Object object) {
        StringBuilder str = new StringBuilder("{");
        Collection<Object> propertyNames = this.getPropertyNames(object);
        for (Object key : propertyNames) {
            Object value = this.getProperty(object, key);
            str.append('\"').append(jsonEscapeHelper.escape(this.toString(key))).append("\":");
            str.append(this.unparse(value));
            str.append(',');
        }
        if (!propertyNames.isEmpty()) {
            str.setLength(str.length() - 1);
        }
        return str.append('}').toString();
    }

    private String unparseArray(Object array) {
        StringBuilder str = new StringBuilder("[");
        List<Object> elements = this.toList(array);
        for (Object element : elements) {
            str.append(this.unparse(element)).append(',');
        }
        if (!elements.isEmpty()) {
            str.setLength(str.length() - 1);
        }
        return str.append(']').toString();
    }
}

