/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.function;

import io.burt.jmespath.Expression;

public abstract class FunctionArgument<T> {
    public static <U> FunctionArgument<U> of(U value) {
        return new V<U>(value);
    }

    public static <U> FunctionArgument<U> of(Expression<U> expression) {
        return new E<U>(expression);
    }

    private FunctionArgument() {
    }

    public Expression<T> expression() {
        return null;
    }

    public T value() {
        return null;
    }

    public boolean isExpression() {
        return false;
    }

    public boolean isValue() {
        return false;
    }

    private static class E<U>
    extends FunctionArgument<U> {
        private final Expression<U> expression;

        public E(Expression<U> expression) {
            this.expression = expression;
        }

        @Override
        public Expression<U> expression() {
            return this.expression;
        }

        @Override
        public boolean isExpression() {
            return true;
        }
    }

    private static class V<U>
    extends FunctionArgument<U> {
        private final U value;

        public V(U value) {
            this.value = value;
        }

        @Override
        public U value() {
            return this.value;
        }

        @Override
        public boolean isValue() {
            return true;
        }
    }
}

