/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.vizualizers;

import java.awt.Color;
import kg.apc.charting.AbstractGraphPanelChartElement;
import kg.apc.charting.AbstractGraphRow;
import kg.apc.charting.elements.GraphPanelChartSimpleElement;
import kg.apc.charting.rows.GraphRowSimple;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.graphs.AbstractOverTimeVisualizer;
import kg.apc.jmeter.graphs.SettingsInterface;
import kg.apc.jmeter.vizualizers.JSettingsPanel;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class ThreadsStateOverTimeGui
extends AbstractOverTimeVisualizer {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private long lastAggUpdateTime = 0L;

    public ThreadsStateOverTimeGui() {
        this.graphPanel.getGraphObject().setYAxisLabel("Number of active threads");
    }

    protected void setExtraChartSettings() {
        this.graphPanel.getGraphObject().getChartSettings().enableDrawFinalZeroingLines();
    }

    private double getAllThreadCount(long time) {
        double ret = 0.0;
        for (AbstractGraphRow row : this.model.values()) {
            if (time > row.getMaxX() + (long)row.getGranulationValue()) continue;
            AbstractGraphPanelChartElement element = row.getElement(time);
            if (element == null) {
                element = row.getLowerElement(time);
            }
            if (element == null) continue;
            ret += element.getValue();
        }
        return ret;
    }

    private void rebuildAggRow(GraphRowSimple row, long time, long duration) {
        long key = row.getHigherKey(this.lastAggUpdateTime - duration - 1L);
        while (key < time && key != -1L) {
            GraphPanelChartSimpleElement elt = (GraphPanelChartSimpleElement)row.getElement(key);
            elt.add(this.getAllThreadCount(key));
            Long nextKey = row.getHigherKey(key);
            if (nextKey != null) {
                key = nextKey;
                continue;
            }
            key = -1L;
        }
    }

    private void addThreadGroupRecord(String threadGroupName, long time, int numThreads, long duration) {
        String labelAgg = "Overall Active Threads";
        AbstractGraphRow row = (AbstractGraphRow)this.model.get(threadGroupName);
        AbstractGraphRow rowAgg = (AbstractGraphRow)this.modelAggregate.get(labelAgg);
        if (row == null) {
            row = this.getNewRow(this.model, 0, threadGroupName, 2, false, false, false, true, true);
        }
        if (rowAgg == null) {
            rowAgg = this.getNewRow(this.modelAggregate, 6, labelAgg, 2, false, false, false, true, Color.RED, true);
        }
        row.add(time, (double)numThreads);
        if (this.model.size() == 1) {
            log.debug(row.toString());
            log.debug(row.getElement(time).toString());
            rowAgg.add(time, row.getElement(time).getValue());
        } else {
            rowAgg.add(time, this.getAllThreadCount(time));
            if (time < this.lastAggUpdateTime) {
                this.lastAggUpdateTime = time - duration;
            }
            if (time != this.lastAggUpdateTime) {
                this.rebuildAggRow((GraphRowSimple)rowAgg, time, duration);
            }
            this.lastAggUpdateTime = time;
        }
    }

    public String getLabelResource() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel((String)"Active Threads Over Time");
    }

    public void add(SampleResult res) {
        if (!this.isSampleIncluded(res)) {
            return;
        }
        super.add(res);
        String threadName = res.getThreadName();
        threadName = threadName.lastIndexOf(" ") >= 0 ? threadName.substring(0, threadName.lastIndexOf(" ")) : threadName;
        long timeForAgg = Math.max((long)this.getGranulation(), res.getTime());
        this.addThreadGroupRecord(threadName, this.normalizeTime(res.getEndTime()), res.getGroupThreads(), timeForAgg);
        this.updateGui(null);
    }

    protected JSettingsPanel createSettingsPanel() {
        return new JSettingsPanel((SettingsInterface)this, 2971);
    }

    public String getWikiPage() {
        return "ActiveThreadsOverTime";
    }
}

