/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.cmd;

import java.io.File;
import java.util.Iterator;
import java.util.Map;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.cmd.Shell;
import org.hyperic.sigar.cmd.SigarCommandBase;
import org.hyperic.sigar.win32.FileVersion;
import org.hyperic.sigar.win32.Win32;

public class FileVersionInfo
extends SigarCommandBase {
    public FileVersionInfo(Shell shell) {
        super(shell);
    }

    public FileVersionInfo() {
    }

    protected boolean validateArgs(String[] args) {
        return args.length >= 1;
    }

    public String getUsageShort() {
        return "Display file version info";
    }

    public void output(String[] args) throws SigarException {
        for (int i = 0; i < args.length; ++i) {
            String exe = args[i];
            if (new File(exe).exists()) {
                this.output(exe);
                continue;
            }
            long[] pids = this.shell.findPids(exe);
            for (int j = 0; j < pids.length; ++j) {
                try {
                    this.output(this.sigar.getProcExe(pids[j]).getName());
                    continue;
                }
                catch (SigarException e) {
                    this.println(exe + ": " + e.getMessage());
                }
            }
        }
    }

    private void output(String key, String val) {
        int max = 20;
        int len = 20 - key.length();
        StringBuffer sb = new StringBuffer();
        sb.append("  ").append(key);
        while (len-- > 0) {
            sb.append('.');
        }
        sb.append(val);
        this.println(sb.toString());
    }

    public void output(String exe) throws SigarException {
        FileVersion info = Win32.getFileVersion(exe);
        if (info == null) {
            return;
        }
        this.println("Version info for file '" + exe + "':");
        this.output("FileVersion", info.getFileVersion());
        this.output("ProductVersion", info.getProductVersion());
        Iterator it = info.getInfo().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            this.output((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public static void main(String[] args) throws Exception {
        new FileVersionInfo().processCommand(args);
    }
}

